package server.parser;

import server.parser.Formatter.ProverNineFormatter;
import server.parser.node.Node;

public class ProverNineFormula extends Formula {
	private static final long serialVersionUID = -7257258152530578843L;

	/**
	 * Erstellt eine exakte (tiefe) Kopie der uebergebenen Formel, die allerdings
	 * bei toString() in Prover9-Syntax ausgegeben wird.
	 * @param formula Formel, die in einer anderen Syntax ausgegeben werden soll.
	 */
	public ProverNineFormula( Node formula ) {
		super( formula );
	}
	
	@Override
	public String toString() {
		return this.getRootChild().toString(new ProverNineFormatter());
	}	

}
