package server.parser;

import server.parser.Formatter.FormulaFormatter;

public class MumFormula extends Formula {
	private static final long serialVersionUID = -2840271909082033395L;

	/**
	 * Erstellt eine MumFormula, bei der nicht gezeigt wird, welche
	 * Anfrage verweigert wurde.
	 */
	public MumFormula() {
	}
	
	/**
	 * Erstellt eine MumFormula, die als Syntaxbaum die urspruengliche
	 * Anfrage enthaelt. Bei der Ausgabe ueber toString() wird
	 * die urspruengliche Anfrage mit ausgegeben.
	 * @param formula Anfrage, die verweigert wurde.
	 */
	public MumFormula( Formula formula ) {
		super( formula );
	}
	
	@Override
	public String toString(FormulaFormatter formulaformatter) {
		if ( this.getRootChild() != null )
			return formulaformatter.getMum()+" ( " + super.toString(formulaformatter) + " )";
		else
			return formulaformatter.getMum();
	}
}
