package server.database.schema.maintenance;

import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;
import exception.DatabaseException;

/**
 * Tabellen-Schema fuer das Experiment zum statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesExperimentEvaluationCumulatedSchema extends TableSchema {
	
	public final static String TABLE_NAME = "SIGS_EXPERIMENT_EVAL_CUM";
	public final static SchemaColumn RUN_ID = new SchemaColumn("RUN_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn QUERY_COUNT = new SchemaColumn("QUERY_COUNT", "NUMBER(7,0)", true);
	public final static SchemaColumn TRUE_COUNT = new SchemaColumn("TRUE_COUNT", "NUMBER(7,0)", true);
	public final static SchemaColumn FALSE_COUNT = new SchemaColumn("FALSE_COUNT", "NUMBER(7,0)", true);
	public final static SchemaColumn MUM_COUNT = new SchemaColumn("MUM_COUNT", "NUMBER(7,0)", true);
	public final static SchemaColumn PROCESSING_TIME_MAX = new SchemaColumn("PROCESSING_TIME_MAX", "NUMBER(7,0)", true);
	public final static SchemaColumn PROCESSING_TIME_SUM = new SchemaColumn("PROCESSING_TIME_SUM", "NUMBER(7,0)", true);
	public final static SchemaColumn DATABASE_PROCESSING_TIME_MAX = new SchemaColumn("DATABASE_PROCESSING_TIME_MAX", "NUMBER(7,0)", true);
	public final static SchemaColumn DATABASE_PROCESSING_TIME_SUM = new SchemaColumn("DATABASE_PROCESSING_TIME_SUM", "NUMBER(7,0)", true);
	
	
	public SignaturesExperimentEvaluationCumulatedSchema() throws DatabaseException {
		super(TABLE_NAME, RUN_ID, QUERY_COUNT, TRUE_COUNT, FALSE_COUNT, MUM_COUNT, PROCESSING_TIME_MAX, PROCESSING_TIME_SUM, DATABASE_PROCESSING_TIME_MAX, DATABASE_PROCESSING_TIME_SUM);
	}
}
