package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class LogTableSchema extends TableSchema {

	public final static SchemaColumn ID = new SchemaColumn("ID", "NUMBER(7,0)", true, true, true);
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7,0)", true, UserTableSchema.ID);
	public final static SchemaColumn INTERACTIONTYPE = new SchemaColumn("INTERACTIONTYPE", "VARCHAR2(40 BYTE)");
	public final static SchemaColumn INTERACTION = new SchemaColumn("INTERACTION", "VARCHAR2(400 BYTE)");
	public final static SchemaColumn INTERACTIONDATE = new SchemaColumn("INTERACTIONDATE", "DATE", "sysdate");
	public final static SchemaColumn ANSWER = new SchemaColumn("ANSWER", "CLOB");
	public final static SchemaColumn ANSWERFORMULATYPE = new SchemaColumn("ANSWERFORMULATYPE", "VARCHAR2(40 BYTE)");
	public final static SchemaColumn EFFECTIVE_UPDATES = new SchemaColumn("EFFECTIVE_UPDATES", "VARCHAR2(400 BYTE)");
	
	public LogTableSchema() throws DatabaseException {
		super("LOG", ID, USER_ID, INTERACTIONTYPE, INTERACTION, INTERACTIONDATE, ANSWER, ANSWERFORMULATYPE, EFFECTIVE_UPDATES);
	}
}
