package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class DictionariesTableSchema extends TableSchema {

	public final static SchemaColumn RELATION = new SchemaColumn("RELATION", "VARCHAR2(100 BYTE)", true, true);
	public final static SchemaColumn ATTRIBUTE = new SchemaColumn("ATTRIBUTE", "VARCHAR2(50 BYTE)", true, true);
	public final static SchemaColumn DICT_TABLE = new SchemaColumn("DICT_TABLE", "VARCHAR2(50 BYTE)", true);
	
	public DictionariesTableSchema() throws DatabaseException {
		super("DICTIONARIES", RELATION, ATTRIBUTE, DICT_TABLE);
	}
}
