package server.database.schema.app;

import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;
import exception.DatabaseException;

public abstract class DictTableSchema extends TableSchema {
	
	public final static SchemaColumn ID = new SchemaColumn("ID", "NUMBER(7,0)", true, true, true);
	public final static SchemaColumn ENTRY = new SchemaColumn("ENTRY", "VARCHAR2(100 BYTE)");
	
	public DictTableSchema(String dictName) throws DatabaseException {
		super(dictName, ID, ENTRY);
	}
	
	/**
	 * Must return the contents of the dictionary as an array.
	 * The order of the array will be preserved.
	 * 
	 * @return Contents of the dictionary as String array.
	 */
	public abstract String[] getDictionaryContents();
}
