package server.database.schema;

public class SchemaColumn {
	
	// All Variables are public (for easy access) and final (so no one can tamper with them).
	// Spares us the pain with get/set Methods.
	public final String name;
	public final String type;
	public final boolean notNull;
	public final boolean primary;
	public final boolean autoincrement;
	public final boolean unique;
	public final SchemaColumn foreignKey;
	public final String defaultValue;
	public final String[] allowedValues;
	
	// The table is only available after initialization, so it can be accessed by the normal get/set methods.
	private TableSchema parent;
	

	public SchemaColumn( String name, String type ) {
		this( name, type, false, false, false, false, null, null );
	}
	
	public SchemaColumn( String name, String type, String defaultValue ) {
		this( name, type, false, false, false, false, null, defaultValue );
	}
	
	public SchemaColumn( String name, String type, SchemaColumn foreignKey ) {
		this( name, type, false, false, false, false, foreignKey, null );
	}
	
	public SchemaColumn( String name, String type, SchemaColumn foreignKey, String defaultValue ) {
		this( name, type, false, false, false, false, foreignKey, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull ) {
		this( name, type, notNull, false, false, false, null, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, String defaultValue ) {
		this( name, type, notNull, false, false, false, null, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, SchemaColumn foreignKey ) {
		this( name, type, notNull, false, false, false, foreignKey, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, SchemaColumn foreignKey, String defaultValue ) {
		this( name, type, notNull, false, false, false, foreignKey, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary ) {
		this( name, type, notNull, primary, false, false, null, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, String defaultValue ) {
		this( name, type, notNull, primary, false, false, null, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, SchemaColumn foreignKey ) {
		this( name, type, notNull, primary, false, false, foreignKey, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, SchemaColumn foreignKey, String defaultValue ) {
		this( name, type, notNull, primary, false, false, foreignKey, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, boolean autoincrement ) {
		this( name, type, notNull, primary, autoincrement, false, null, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, boolean autoincrement, String defaultValue ) {
		this( name, type, notNull, primary, autoincrement, false, null, defaultValue );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, boolean autoincrement, SchemaColumn foreignKey ) {
		this( name, type, notNull, primary, autoincrement, false, foreignKey, null );
	}
	
	public SchemaColumn( String name, String type, boolean notNull, boolean primary, boolean autoincrement, SchemaColumn foreignKey, String defaultValue, String ... allowedValues ) {
		this( name, type, notNull, primary, autoincrement, false, foreignKey, defaultValue, allowedValues );
	}

	public SchemaColumn( String name, String type, boolean notNull, boolean primary, boolean autoincrement, boolean unique, SchemaColumn foreignKey, String defaultValue, String ... allowedValues ) {
		this.name = name;
		this.type = type;
		this.notNull = notNull;
		this.primary = primary;
		this.autoincrement = autoincrement;
		this.unique = unique;
		this.foreignKey = foreignKey;
		this.defaultValue = defaultValue;
		this.allowedValues = allowedValues;
	}
	
	
	public TableSchema getParent() {
		return this.parent;
	}
	
	public void setParent( TableSchema parent ) {
		this.parent = parent;
	}
	
	/**
	 * Returns the column name prefixed with the table name
	 * (separated by a dot). Example: "table.column"
	 * @return Full name of the column including the table name.
	 */
	public String getFullName() {
		if ( this.parent != null ) {
			return this.parent.name + "." + this.name;
		} else {
			return this.name;
		}
	}
}
