package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;

import communication.CqeType;

import exception.DatabaseException;
import server.core.Client;
import server.data.User;
import user.ConfidentialityPolicyItem;
import user.IdAndFormula;
import notification.clientToServer.AddUserNotification;
import notification.serverToClient.OkayNotification;

public class AddUserNotificationHandler extends NotificationHandler<AddUserNotification> {

	public AddUserNotificationHandler() {
		super(AddUserNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, AddUserNotification notification) throws IOException, DatabaseException {		
		User user = client.getMaintenanceDB().getUserManagement().add(notification.getName());
		
		// FIXME: Workaround until new communication protocol is available 
		user.Role role = new user.Role(user.getRole().getName());
		user.User userCopy = new user.User( user.getId(), user.getUsername(), role, new LinkedList<ConfidentialityPolicyItem>(), new LinkedList<IdAndFormula>(), user.getCensor(), new LinkedList<IdAndFormula>(), new LinkedList<IdAndFormula>(), new LinkedList<IdAndFormula>() );
		
		client.send( new OkayNotification(userCopy) );
	}

}
