package server.censor;

import java.util.LinkedList;
import java.util.List;

import notification.serverToClient.QueryResultNotification;
import server.core.Client;
import server.core.Server;
import server.data.LogEntry;
import server.parser.Formula;
import server.parser.MumFormula;
import user.IdAndFormula;

public abstract class QueryCensor extends Censor {

	public QueryCensor(String censorName, Server server) {
		super(censorName, server);
	}
	
	public QueryResultNotification evaluate( Client client, Formula interaction ) throws Exception {
		List<IdAndFormula> result = new LinkedList<IdAndFormula>();
		List<IdAndFormula> addToLog = new LinkedList<IdAndFormula>();
				
		// Create a deep copy of the formula.
		Formula copy = new Formula( interaction );

		// Run the actual censor.
		List<Formula> censorResult = this.run( client, copy );
		
		// Do some post-processing with the result.
		for ( Formula answer : censorResult ) {
			if ( !(answer instanceof MumFormula) ) {
				// Add answer to log if not MUM.
				LogEntry entry = client.getUser().getLog().add(interaction, null, answer, null);
				IdAndFormula logEntry = new IdAndFormula(entry.getId(), answer);
				result.add( logEntry );
				addToLog.add( logEntry );
			} else {
				// MUM => no log entry, but add to result.
				result.add( new IdAndFormula(-1, answer) );
			}
		}
		
		return new QueryResultNotification( result, interaction.toString(), addToLog );
	}
	
	/**
	 * The actual handling of the interaction is done in this method.
	 * Every query censor must implement it.
	 * 
	 * @param client
	 * @param interaction
	 * @return
	 * @throws Exception
	 */
	protected abstract List<Formula> run( Client client, Formula interaction ) throws Exception;
}
