/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exception;

import java.util.ArrayList;
import java.util.List;

import server.parser.ParseException;
import server.parser.Token;

public class ParserException extends CqeException {
	private static final long serialVersionUID = -5390247493547099247L;
	
	private String errorToken;
    private String reconizedToken;
    private List<String> expectedToken = new ArrayList<String>();
    private int position;
    private String[] tokenImage;
    public int[][] expectedTokenSequences;
    private Token currentToken;

    public ParserException(ParseException parseException) {
    	super( "", null );
    	
        this.currentToken = parseException.currentToken;
        this.tokenImage = parseException.tokenImage;
        this.expectedTokenSequences = parseException.expectedTokenSequences;
        notification();
        
        this.setMessage("Parser error\n"+parseException.toString());
    }

    private void notification() {
        StringBuilder foundToken = new StringBuilder();
        StringBuilder err = new StringBuilder();
        int maxSize = 0;
        for (int i = 0; i < expectedTokenSequences.length; i++) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; j++) {
                expectedToken.add(tokenImage[expectedTokenSequences[i][j]]);
            }
        }
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; i++) {
            if (tok.kind == 0) {
                foundToken.append(tokenImage[0]);
                break;
            }
            foundToken.append(" ");
            foundToken.append(tokenImage[tok.kind]);
            err.append(tok.image);
            tok = tok.next;
        }
        position = currentToken.next.beginColumn;
        reconizedToken = foundToken.toString();
        errorToken = err.toString();
    }

    public String getErrorToken() {
        return errorToken;
    }

    public List<String> getExpectedToken() {
        return expectedToken;
    }

    public int getPosition() {
        return position;
    }

    public String getReconizedToken() {
        return reconizedToken;
    }

}
