package exception;

public class CqeException extends Exception {
	private static final long serialVersionUID = -785666170079529675L;
	
	private String msg;
	private Exception originalException;

	public CqeException( String msg, Exception originalException ) {
		this.msg = msg;
		this.originalException = originalException;
	}
	
	/**
	 * Diese Funktion wurde nur angelegt, um in abgeleiteten Klassen das Setzen des Error-Strings
	 * im Konstruktor zu ermoeglichen. Normalerweise wuerde dies ueber die super()-Anweisung
	 * passieren, allerdings muss die Fehlermeldung erst korrekt zusammengestellt werden
	 * (z.B. ProverException). Da super() immer die erste Anweisung sein muss, kann dort zuerst
	 * der leere String "" uebergeben werden und spaeter im Konstruktor diese Methode aufgerufen werden.
	 * @param msg
	 */
	protected void setMessage( String msg ) {
		this.msg = msg;
	}
	
	public String getMessage() {
		return this.msg;
	}
	
	public Exception getOriginalException() {
		return this.originalException;
	}
}
