package communication;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

import org.apache.log4j.Logger;


import notification.Notification;


public class SocketCommunication implements Communication {
	private final static Logger logger = Logger.getLogger("edu.udo.cs.ls6.cie.server.core");

	private Socket clientSocket = null;
	private ObjectOutputStream output = null;
	private ObjectInputStream input  = null;
	
	public SocketCommunication( Socket clientSocket ) throws IOException {
		this.clientSocket = clientSocket;
		
		// Dummy-Clients (for test cases) have no sockets
		if ( clientSocket != null ) {
			this.output = new ObjectOutputStream( this.clientSocket.getOutputStream() );
			this.input = new ObjectInputStream( this.clientSocket.getInputStream() );
		}
	}
	
	/**
	 * Closes the connection to the client.
	 */
	@Override
	public void disconnect() {
		logger.debug("Disconnecting from client "+this.clientSocket.getRemoteSocketAddress());
		try {
			this.output.close();
			this.input.close();
			this.clientSocket.close();
		} catch ( IOException e ) {
			logger.debug( "IOException upon client disconnect", e );
		}
	}

	@Override
	public Notification recv() throws IOException {
		Notification notification = null;
		try {
			notification = (Notification)this.input.readObject();
		} catch (ClassNotFoundException e) {
			logger.error( "Message has the wrong class type! Incompatible client server versions?" );
			throw new IOException( "Message has the wrong class type! Incompatible client server versions?" );
		}
		
		return notification;
	}

	@Override
	public void send(Notification notification) throws IOException {
		this.output.writeObject( notification );
	}

}
