package communication;

import java.io.IOException;

import notification.Notification;


/**
 * Schnittstelle, die fuer einen Kommunikationskanal verwendet wird. Da eine bidirektionale Kommunikation
 * zwischen Application und GUI stattfindet, muss es auch zwei Kommunikationskanaele geben.
 * @see cqe.core.Buffer
 * @author Dirk Schalge
 *
 */
public interface Communication {
	/**
	 * Closes the connection to the client.
	 */
	public void disconnect();
	
	/**
	 * Sendet eine Notification in den Empfaenger (GUI oder Application). Der Empfaenger muss anhand des
	 * Notification-Typs entscheiden, welche weiteren Aktionen (z.B. GUI-Update) erforderlich sind.
	 * Die Notification selber dienen zudem zur Datenkapselung.
	 * @param notification Notification, die an die GUI gesendet werden soll.
	 */
	public void send(Notification notification) throws IOException;
	
	/**
	 * Dient zur Verarbeitung einer empfangenen Notification. Anhand der Notification wird entschieden, welche
	 * weiteren Aktionen (z.B. GUI-Update) erforderlich sind.
	 * @return notification Die empfangene Notification.
	 */
	public Notification recv() throws IOException;
}
