package client.gui.usermanagement;

import java.awt.Component;
import java.awt.Font;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


import user.ConfidentialityPolicyItem;
import user.IdAndFormula;
import user.User;

/**
 * GUI-Element: Zeigt alle Details (log, potential secrets, aktueller Zustand,
 * Rolle) fuer einen bestimmten Benutzer an und bietet Manipulationsmoeglichkeiten.
 * @author schalge
 */
public class UserDetailPanel extends JPanel implements ListSelectionListener {
	private static final long serialVersionUID = -8031670597634601177L;
	
    private JLabel userLabel = null;
    private UserOverviewPanel userOverviewPanel = null;
    
    private UserInformationListPanel priorPanel = null;
    private UserInformationListPanel logPanel = null;
    private UserConfidentialityPolicyPanel confPolicyPanel = null;
    private PreCQEPanel preCQEPanel = null;
    
    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public UserDetailPanel( UserOverviewPanel userOverviewPanel ) {
    	this.userOverviewPanel = userOverviewPanel;
    	this.userOverviewPanel.getSelectionModel().addListSelectionListener( this );
    	
        this.setLayout( new BoxLayout(this, BoxLayout.Y_AXIS) );
        this.setBorder( BorderFactory.createEmptyBorder(10, 10, 10, 10));

        this.userLabel = new JLabel("Username");
        this.userLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
        this.userLabel.setFont( new Font(this.userLabel.getFont().getFamily(), Font.BOLD, 30) );
        this.add( this.userLabel );
        
        this.priorPanel = new UserInformationListPanel("Prior", userOverviewPanel);
        this.add( this.priorPanel );
        
        this.confPolicyPanel = new UserConfidentialityPolicyPanel(userOverviewPanel);
        this.add( this.confPolicyPanel );
        
        this.logPanel = new UserInformationListPanel("Log", userOverviewPanel);
        this.add( this.logPanel );
        
        this.preCQEPanel = new PreCQEPanel(userOverviewPanel);
        this.add( this.preCQEPanel );
    }

	@Override
	public void valueChanged(ListSelectionEvent e) {
		// Wir erlauben nur die Selektion eines Elements.
		int selectedIndex = this.userOverviewPanel.getSelectionModel().getLeadSelectionIndex();
		// Wenn selectedIndex == -1, dann wurde ein Element geloescht.
		if ( selectedIndex >= 0 && selectedIndex < this.userOverviewPanel.getUserModel().getRowCount() ) {
			User user = this.userOverviewPanel.getUserModel().getUser( selectedIndex );
		
			// Update panels
			this.userLabel.setText( user.getUsername() );
			this.logPanel.getModel().setList( user.getOriginalLog() );
			this.confPolicyPanel.getModel().setList( user.getConfidentialityPolicy() );
			this.priorPanel.getModel().setList( user.getPrior() );
		} else {
			// Update panels
			this.userLabel.setText( "" );
			this.logPanel.getModel().setList( new Vector<IdAndFormula>() );
			this.confPolicyPanel.getModel().setList( new Vector<ConfidentialityPolicyItem>() );
			this.priorPanel.getModel().setList( new Vector<IdAndFormula>() );
		}
	}

}
