package client.gui.usermanagement;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

/**
 * GUI-Element: Zeigt die Liste aller Benutzer. Bietet die Möglichkeit neue
 * Benutzer anzulegen oder markierte Benutzer zu löschen.
 * @author schalge
 */
public class UserControlPanel extends JPanel {
	private static final long serialVersionUID = -1060087675298463530L;
	
	private JTextField nameTextField = null;
    private JButton addButton = null;
    private JButton delButton = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public UserControlPanel() {
        JLabel nameLabel = new JLabel( "Name:" );
        this.add ( nameLabel );


        nameTextField = new JTextField();
        nameTextField.setColumns( 20 );
        this.add( nameTextField );

        addButton = new JButton("Add User");
        this.add( addButton );

        JSeparator sep = new JSeparator();
        sep.setOrientation( JSeparator.VERTICAL );
        this.add( sep );

        delButton = new JButton("Delete User");
        this.add( delButton );
    }
    
    public JButton getAddButton() {
    	return this.addButton;
    }
    
    public JButton getDeleteButton() {
    	return this.delButton;
    }
    
    public String getText() {
    	return this.nameTextField.getText();
    }
}
