package client.gui.usermanagement;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import notification.serverToClient.ExceptionNotification;

import user.ConfidentialityPolicyItem;
import user.IdAndFormula;
import client.core.Client;

import communication.CqeType;
import exception.ParserException;


public class UserConfidentialityPolicyPanel extends JPanel implements ActionListener  {
	private static final long serialVersionUID = -2295171442376534822L;
	
	private ConfidentialityPolicyModel confPolModel = null;
	private JTable confPolTable = null;
	private UserManagementControlPanel controlPanel = null;
	private UserOverviewPanel userOverviewPanel = null;
	
	public UserConfidentialityPolicyPanel( UserOverviewPanel userOverviewPanel ) {
		this.userOverviewPanel = userOverviewPanel;
		
		// Some layouting
		this.setLayout( new BorderLayout() );
        this.setBorder( BorderFactory.createTitledBorder("Confidentiality Policy") );
        
        // initially select the first user
        int initialSelectedUser = this.userOverviewPanel.getUserModel().getUsers().get(0).getUserId();
        this.confPolModel = new ConfidentialityPolicyModel( initialSelectedUser );
        this.confPolTable = new JTable( this.confPolModel );
        this.confPolTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        // Sortieren deaktivieren, da sonst beim Loeschen die falschen Eintraege geloescht werden!
        // -> Sortierungs-Synchronisation mit dahinter liegenden Daten einbauen
        // this.confPolTable.setAutoCreateRowSorter( true );
        
        // ComboBox fuer Policy und Preservation Type
        JComboBox policyTypeBox = new JComboBox( CqeType.PolicyType.values() );
        this.confPolTable.getColumnModel().getColumn(1).setCellEditor( new DefaultCellEditor(policyTypeBox) );
        
        JComboBox preservationTypeBox = new JComboBox( CqeType.PolicyPreservation.values() );
        this.confPolTable.getColumnModel().getColumn(2).setCellEditor( new DefaultCellEditor(preservationTypeBox) );
        
        // Scrollen ermoeglichen.
        JScrollPane scrollpane = new JScrollPane( this.confPolTable );
        this.add( scrollpane, BorderLayout.CENTER );
        
        // Buttons unten
        this.controlPanel = new UserManagementControlPanel();
        this.controlPanel.getNewButton().addActionListener( this );
        this.controlPanel.getDelButton().addActionListener( this );
        this.add( this.controlPanel, BorderLayout.SOUTH );
	}
	
	public ConfidentialityPolicyModel getModel() {
		return this.confPolModel;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if ( e.getActionCommand().equals("New Item") )	{
			UserAddConfidentialityPolicyDialogPanel panel = new UserAddConfidentialityPolicyDialogPanel();
			int selection = JOptionPane.showConfirmDialog(this, panel, "Create new Confidentiality Policy Item", JOptionPane.OK_CANCEL_OPTION, JOptionPane.DEFAULT_OPTION);
			if (selection == JOptionPane.OK_OPTION){
				try {
					ConfidentialityPolicyItem conf_pol_item = panel.getResult();
					ConfidentialityPolicyItem insertedConfPolItem =  Client.GUI.addUserInformationConfidentialityPolicyEntry( this.userOverviewPanel.getSelectedUser().getUserId(), conf_pol_item );
					if ( insertedConfPolItem != null ) {
						this.getModel().addConfidentialityPolicyItem(insertedConfPolItem);
					}
				}
				catch( ParserException ex ) {
					// Fehler beim Parsen der Formula
					Client.GUI.showError("Error! The speciefied formula could not be parsed.", ex, ExceptionNotification.NONCRITICAL);
					return;
				}
				catch( IOException ex ) {
					// Fehler beim Uebermitteln der Daten an den Server
					Client.GUI.showError("Error while sending the request to the server.", ex, ExceptionNotification.NONCRITICAL);
					return;
				}
			}
			else {
				// Abbrechen-Button geklickt
				return;
			}
		}
		else if ( e.getActionCommand().equals("Delete Item") ) {
			int selectedIndex = this.confPolTable.getSelectionModel().getLeadSelectionIndex();
			if( this.confPolTable.getRowCount() == 0 ) {
				// kein Element zum Loeschen vorhanden
				JOptionPane.showMessageDialog(this, "There exists no item to remove!", "Error", JOptionPane.ERROR_MESSAGE);
				return;
			}
			else if( selectedIndex == -1 ) {
				// kein Element ausgewaehlt
				JOptionPane.showMessageDialog(this, "No element selected!", "Error", JOptionPane.ERROR_MESSAGE);
				return;
			}
			
			ConfidentialityPolicyItem conf_pol_item = this.confPolModel.getConfidentialityPolicyItem(selectedIndex);
			try {
				if ( Client.GUI.deleteUserInformationEntry(IdAndFormula.TYPE_CONF_POL, conf_pol_item.getId(), this.userOverviewPanel.getSelectedUser().getUserId()) ) {
					this.getModel().deleteConfidentialityPolicyItem( selectedIndex );
				}
			} catch (IOException ex) {
				Client.GUI.showError("Error while sending the request to the server.", ex, ExceptionNotification.NONCRITICAL);
				return;
			}
		}
	}
}
