package client.gui.mainwindow;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import client.core.Client;

/**
 * GUI-Element: Statuszeile im Hauptfenster. Zeigt die gerade oder zuletzt
 * ausgefuehrte Aktion an.
 * @author schalge
 */
public class StatusPanel extends JPanel {
	private static final long serialVersionUID = -4862634988965512852L;
	
	private JLabel text = null;
    private JLabel spinner = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public StatusPanel() {
        this.setLayout( new BorderLayout() );
        this.setBorder( BorderFactory.createLoweredBevelBorder() );

        this.spinner = new JLabel( Client.imgDB.smallSpinner );
        this.spinner.setVisible( false );
        this.add( this.spinner, BorderLayout.EAST );
        
        this.text = new JLabel( "Ready" );
        this.text.setBorder( BorderFactory.createEmptyBorder(5, 5, 5, 5) );
        this.add( text, BorderLayout.WEST );
    }

    /**
     * Setzt den Text der Statuszeile auf den angegebenen Wert und deutet
     * grafisch an, dass noch eine Berechnung laeuft.
     * @param text
     */
    public void setBusyStatus( String text ) {
        this.spinner.setVisible( true );
        this.text.setText( text );
    }

    /**
     * Setzt den Text der Statuszeile auf den angegebenen Wert und zeigt an,
     * dass gerade keine Berechnung laeuft.
     * @param text
     */
    public void setStatus( String text ) {
        this.spinner.setVisible( false );
        this.text.setText( text );
    }
}
