package client.gui.mainwindow;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

/**
 * GUI-Element: Zeigt den unteren Teil des Hauptfensters mit Tab-Leiste,
 * Hilfeleiste und Statuszeile an.
 * @author schalge
 */
public class MainPanel extends JPanel {
	private static final long serialVersionUID = -216105873886669705L;
	
	private InputPanel inputPanel = null;
    private TabPanel tabPanel = null;
    private StatusPanel statusPanel = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public MainPanel() {
        super();

        BorderLayout layout = new BorderLayout();
        layout.setVgap( 5 );
        this.setLayout( layout );
        this.setBorder( BorderFactory.createEmptyBorder(5, 0, 0, 0) );

        this.inputPanel = new InputPanel();
        this.tabPanel = new TabPanel();
        this.statusPanel = new StatusPanel();

        // add mouse listener for help-panel
        this.inputPanel.inputTextArea.addMouseListener( this.tabPanel.helpPanel );

        this.add( this.inputPanel, BorderLayout.NORTH );
        this.add( this.tabPanel, BorderLayout.CENTER );
        this.add( this.statusPanel, BorderLayout.SOUTH );
    }
    
    public TabPanel getTabPanel() {
    	return this.tabPanel;
    }

}
