package client.gui.mainwindow;

import java.awt.Font;

import javax.swing.JList;
import javax.swing.JScrollPane;

import client.gui.ListModel;

import user.IdAndFormula;

/**
 * GUI-Tab: Zeigt den Inhalt des Tabs fuer das Log eines Benutzers an.
 * @author schalge
 */
public class LogTabPanel extends LoadingTabPanel {
	private static final long serialVersionUID = -1863655537821674578L;
	
	private JList logList = null;
    private ListModel<IdAndFormula> logModel = null;

    /**
     * Erzeugt den Inhalt des Tabs.
     */
    @Override
    public void createContent() {
    	this.logModel = new ListModel<IdAndFormula>();
        this.logList = new JList( this.logModel );
        this.logList.setFont( new Font("Times New Roman", Font.PLAIN, 16) );

        JScrollPane scrollpane = null;
        scrollpane = new JScrollPane(this.logList);
        this.add(scrollpane);
    }
    
    public void setModel( ListModel<IdAndFormula> model ) {
    	this.logModel = model;
    	this.logList.setModel( model );
    }
}
