package client.gui.mainwindow;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import notification.serverToClient.ExceptionNotification;

import client.core.Client;




/**
 * GUI-Element: Zeigt die Eingabezeile fuer Querys und Updates mit den
 * dazugehoerigen Buttons.
 * @author schalge
 */
public class InputPanel extends JPanel implements ActionListener {
	private static final long serialVersionUID = -721022568380431360L;
	
	public JTextArea inputTextArea = null;
    private JButton queryButton = null;

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public InputPanel() {
        super();

        this.setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100) );

        this.inputTextArea = new JTextArea();
        this.inputTextArea.setFont( new Font("Times New Roman", Font.PLAIN, 16) );
        this.inputTextArea.getDocument().putProperty("filterNewlines", true);
        this.inputTextArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.inputTextArea);
        scrollPane.setMaximumSize(new Dimension(scrollPane.getMaximumSize().width, 100) );
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, 100) );
        this.add( scrollPane );

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout( new BoxLayout(buttonPanel, BoxLayout.Y_AXIS) );

        this.queryButton = new JButton("Send Interaction");
        this.queryButton.addActionListener( this );
        this.queryButton.setSize( new Dimension(this.queryButton.getPreferredSize().width, this.queryButton.getPreferredSize().height*2) );
        this.queryButton.setPreferredSize( this.queryButton.getSize() );
        this.queryButton.setMaximumSize( this.queryButton.getSize());
        buttonPanel.add( this.queryButton );

        this.add( buttonPanel );
    }

    /**
     * Behandelt das Druecken des Update- oder Query-Buttons. Fragt den
     * Inhalt des Textfeldes ab und fuehrt entsprechend die Aktion in der
     * Kontrollklasse aus.
     * @param e
     */
    public void actionPerformed(ActionEvent e) {
    	try {
    		if ( e.getSource() == this.queryButton ) {
    			Client.GUI.interaction( this.inputTextArea.getText().trim() );
    		}
    	} catch ( IOException exception ) {
    		Client.GUI.showError("IO-Error while performing interaction", exception, ExceptionNotification.NONCRITICAL );
    	}
    }
}
