/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.datasettools.Dataset;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.SparseFormatDataRowReader;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SimpleResultObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.tools.AppendingExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetWriterExtended
extends AppendingExampleSetWriter {
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";
    public static final String PARAMETER_ATTRIBUTE_DESCRIPTION_FILE = "attribute_description_file";
    public static final String PARAMETER_FORMAT = "format";
    public static final String PARAMETER_ZIPPED = "zipped";
    public static final String PARAMETER_WRITE = "write";
    public static final String PARAMETER_RELATIVE = "relative";
    private static final String[] FORMAT_NAMES = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 1];
    private static final int DENSE_FORMAT = 0;
    private String amlData;
    private String dataName;
    private OutputPort amlPort = (OutputPort)this.getOutputPorts().createPort("aml");

    public ExampleSetWriterExtended(OperatorDescription description) {
        super(description);
        this.amlData = new String();
        this.dataName = new String();
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
        SimpleResultObject responce = new SimpleResultObject(this.dataName, this.amlData);
        this.amlPort.deliver((IOObject)responce);
    }

    @Override
    public ExampleSet write(ExampleSet eSet) throws OperatorException {
        String amlFileName;
        boolean zipped = this.getParameterAsBoolean(PARAMETER_ZIPPED);
        boolean writeDataToFile = this.getParameterAsBoolean(PARAMETER_WRITE);
        boolean relative_path = this.getParameterAsBoolean(PARAMETER_RELATIVE);
        File dataFile = relative_path ? new File(this.getParameterAsString(PARAMETER_EXAMPLE_SET_FILE)) : this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
        System.out.println("Datasource path is " + dataFile.getName());
        if (zipped) {
            dataFile = new File(dataFile.getAbsolutePath() + ".gz");
        }
        File attFile = (amlFileName = this.getParameterAsString(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE)) == null || amlFileName.equals("") ? null : new File(amlFileName);
        System.out.println(attFile != null ? "AML File source is " + attFile.getName() : "attFile path is empty");
        boolean append = this.shouldAppend(dataFile);
        Charset encoding = Encoding.getEncoding((Operator)this);
        boolean writeAmlToFile = attFile != null;
        this.amlData = new Dataset(eSet).prepareAmlFile(writeAmlToFile ? attFile.getPath() : null, dataFile.getPath(), encoding, writeAmlToFile);
        String src = eSet.getAnnotations().get((Object)"Source");
        if (src != null) {
            this.dataName = src.substring(src.lastIndexOf("/") + 1);
        }
        try {
            int format = this.getParameterAsInt(PARAMETER_FORMAT);
            if (format == 0) {
                if (writeDataToFile) {
                    this.getLogger().info("Writing example set in format '" + FORMAT_NAMES[format] + "'.");
                    eSet.writeDataFile(dataFile, -2, true, zipped, append, encoding);
                }
                if (writeAmlToFile) {
                    this.getLogger().info("Writing aml in format '" + FORMAT_NAMES[format] + "'.");
                    eSet.writeAttributeFile(attFile, dataFile, encoding);
                }
            } else {
                if (writeDataToFile) {
                    this.getLogger().info("Writing example set in format '" + FORMAT_NAMES[format] + "'.");
                    eSet.writeSparseDataFile(dataFile, format - 1, -2, true, zipped, append, encoding);
                }
                if (writeAmlToFile) {
                    this.getLogger().info("Writing aml in format '" + FORMAT_NAMES[format] + "'.");
                    eSet.writeSparseAttributeFile(attFile, dataFile, format - 1, encoding);
                }
                this.getLogger().info("Writing example set in format '" + FORMAT_NAMES[format] + "'.");
            }
        }
        catch (IOException e) {
            String errorObjectMessage = dataFile + " / " + (writeAmlToFile ? attFile : "");
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{errorObjectMessage, e.getMessage()});
        }
        return eSet;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        boolean optional = false;
        types.add((ParameterType)new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "dat", optional));
        types.add((ParameterType)new ParameterTypeFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, "File to save the attribute descriptions to.", "aml", !optional));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_WRITE, "Indicates whether the data file should be written as a file.", optional));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_RELATIVE, "Indicates whether the path for the data file should be handled relative.", optional));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ZIPPED, "Indicates if the data file content should be zipped.", optional));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_FORMAT, "Format to use for output.", FORMAT_NAMES, 0));
        types.addAll(super.getParameterTypes());
        return types;
    }

    static {
        ExampleSetWriterExtended.FORMAT_NAMES[0] = "dense";
        for (int i = 0; i < SparseFormatDataRowReader.FORMAT_NAMES.length; ++i) {
            ExampleSetWriterExtended.FORMAT_NAMES[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
        }
    }
}

