/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.SpringUtilities;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.htmltools.SfbCommunication;
import com.rapidminer.operator.tools.DatasetImportWizard;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class FillDataWizardStep
extends WizardStep {
    private JTextField datasetname = new JTextField(25);
    private JTextField dataFileJTextField = new JTextField(50);
    private JTextField amlFileJTextField = new JTextField(50);
    private JTextArea problemDescription = new JTextArea(10, 1);
    private JComboBox accessRightsJComboBox = new JComboBox();
    private JComboBox sfbPartProjectsJComboBox = new JComboBox();
    private JComboBox personsJComboBox = new JComboBox();
    private JLabel datasetnameLabel = new JLabel("Dataset name");
    private JLabel problemDescriptionJLabel = new JLabel("Problem description");
    private JLabel accessRightsJLabel = new JLabel("Access rights");
    private JLabel sfbPartProjectsJLabel = new JLabel("Sfb Part Projects");
    private JLabel personsJLabel = new JLabel("Persons");
    private JLabel dataFileJLabel = new JLabel("Data file");
    private JLabel amlFileJLabel = new JLabel("Aml file");
    private JPanel panel = new JPanel(new SpringLayout());
    private DatasetImportWizard diw;
    private int width = 600;
    private int height = 500;

    public FillDataWizardStep(DatasetImportWizard diw) {
        super("Fill the data");
        this.diw = diw;
        this.panel.add(this.datasetnameLabel);
        this.datasetnameLabel.setLabelFor(this.datasetname);
        this.panel.add(this.datasetname);
        this.panel.add(this.problemDescriptionJLabel);
        this.problemDescription.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.problemDescription, 20, 31);
        this.problemDescriptionJLabel.setLabelFor(scrollPane);
        this.panel.add(scrollPane);
        this.panel.add(this.accessRightsJLabel);
        this.accessRightsJLabel.setLabelFor(this.accessRightsJComboBox);
        this.panel.add(this.accessRightsJComboBox);
        this.panel.add(this.sfbPartProjectsJLabel);
        this.sfbPartProjectsJLabel.setLabelFor(this.sfbPartProjectsJComboBox);
        this.panel.add(this.sfbPartProjectsJComboBox);
        this.panel.add(this.personsJLabel);
        this.personsJLabel.setLabelFor(this.personsJComboBox);
        this.panel.add(this.personsJComboBox);
        this.panel.add(this.dataFileJLabel);
        this.dataFileJLabel.setLabelFor(this.dataFileJTextField);
        this.panel.add(this.dataFileJTextField);
        this.panel.add(this.amlFileJLabel);
        this.amlFileJLabel.setLabelFor(this.amlFileJTextField);
        this.panel.add(this.amlFileJTextField);
        SpringUtilities.makeCompactGrid(this.panel, 7, 2, 5, 5, 10, 5);
        this.datasetname.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                FillDataWizardStep.this.fireStateChanged();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected String getTitle() {
        return "Details about the dataset";
    }

    protected String getInfoText() {
        return "Fill out the details concerning the dataset";
    }

    protected JComponent getComponent() {
        return this.panel;
    }

    protected boolean canProceed() {
        boolean proceed = this.datasetname.getText().length() > 1;
        return proceed;
    }

    protected boolean canGoBack() {
        return true;
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        if (this.diw.getAuthenticated()) {
            int i;
            int len;
            ArrayList<String[]> list;
            this.datasetname.requestFocusInWindow();
            this.diw.setSize(this.width, this.height);
            this.diw.setResizable(false);
            if (this.accessRightsJComboBox.getItemCount() == 0) {
                list = this.diw.getAccessRights();
                len = list.size();
                for (i = 0; i < len; ++i) {
                    this.accessRightsJComboBox.addItem(list.get(i)[1]);
                }
            }
            if (this.diw.getChosenAccessRichts() != -1) {
                this.accessRightsJComboBox.setSelectedIndex(this.diw.getChosenAccessRichts());
            }
            if (this.sfbPartProjectsJComboBox.getItemCount() == 0) {
                list = this.diw.getSfbPartProjects();
                len = list.size();
                for (i = 0; i < len; ++i) {
                    this.sfbPartProjectsJComboBox.addItem(list.get(i)[1]);
                }
            }
            if (this.diw.getChosenSfbPartProjects() != -1) {
                this.sfbPartProjectsJComboBox.setSelectedIndex(this.diw.getChosenSfbPartProjects());
            }
            if (this.personsJComboBox.getItemCount() == 0) {
                list = this.diw.getPersons();
                len = list.size();
                for (i = 0; i < len; ++i) {
                    this.personsJComboBox.addItem(list.get(i)[1] + ", " + list.get(i)[2]);
                    if (!list.get(i)[0].toLowerCase().equals(this.diw.getUserId())) continue;
                    this.personsJComboBox.setSelectedIndex(i);
                }
            }
            if (this.diw.getChosenPersons() != -1) {
                this.personsJComboBox.setSelectedIndex(this.diw.getChosenPersons());
            }
            this.dataFileJTextField.setText(this.diw.getDataFile() != null ? this.diw.getDataFile().getName() : "");
            this.dataFileJLabel.setForeground(Color.BLACK);
            this.amlFileJTextField.setText(this.diw.getAmlFile() != null ? this.diw.getAmlFile().getName() : "");
            this.amlFileJLabel.setForeground(Color.BLACK);
            return super.performEnteringAction(direction);
        }
        this.diw.previous();
        return false;
    }

    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FORWARD) {
            boolean renamed;
            File newname;
            if (this.datasetname.equals("") || this.dataFileJTextField.getText().equals("") || this.amlFileJTextField.getText().equals("")) {
                if (this.dataFileJTextField.getText().equals("")) {
                    this.dataFileJLabel.setForeground(Color.RED);
                } else {
                    this.dataFileJLabel.setForeground(Color.BLACK);
                }
                if (this.amlFileJTextField.getText().equals("")) {
                    this.amlFileJLabel.setForeground(Color.RED);
                } else {
                    this.amlFileJLabel.setForeground(Color.BLACK);
                }
                return false;
            }
            this.diw.setDatasetName(this.datasetname.getText());
            this.diw.setProblemDescription(this.problemDescription.getText());
            this.diw.setChosenAccessRichts(this.accessRightsJComboBox.getSelectedIndex());
            this.diw.setChosenPersons(this.personsJComboBox.getSelectedIndex());
            this.diw.setChosenSfbPartProjects(this.sfbPartProjectsJComboBox.getSelectedIndex());
            String data_name = this.dataFileJTextField.getText();
            String aml_name = this.amlFileJTextField.getText();
            if (this.diw.getAmlFile() == null) {
                this.diw.setAmlFile(new File(aml_name + (aml_name.endsWith(".aml") ? "" : ".aml")));
                this.diw.getAmlFile().deleteOnExit();
            }
            if (this.diw.getDataFile() == null) {
                this.diw.setDataFile(new File(data_name + (data_name.endsWith(".csv") ? "" : ".csv")));
                this.diw.getDataFile().deleteOnExit();
            }
            if (!this.dataFileJTextField.getText().equals(this.diw.getDataFile().getName())) {
                newname = new File(this.dataFileJTextField.getText());
                renamed = this.diw.getDataFile().renameTo(newname);
                if (renamed) {
                    this.diw.setDataFile(newname);
                }
            }
            if (!this.amlFileJTextField.getText().equals(this.diw.getAmlFile().getName())) {
                newname = new File(this.amlFileJTextField.getText());
                renamed = this.diw.getAmlFile().renameTo(newname);
                if (renamed) {
                    this.diw.setAmlFile(newname);
                }
            }
            new SfbCommunication().doInfolayerActions(this.diw, 1);
        }
        if (direction == AbstractWizard.WizardStepDirection.BACKWARD) {
            this.diw.setDatasetName("");
        }
        return super.performLeavingAction(direction);
    }
}

