/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.tools.ParameterTypeParameterInternal;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.ParameterService;
import java.util.Iterator;
import java.util.List;

public class SetRapidminerParameters
extends Operator {
    public static final String PARAMETER_TO_BE_CHANGED = "parameter_to_change";
    public static final String PARAMETER_VALUE = "parameter_value";
    public static final String PARAMETER_COLUMN_NAME = "Value";
    public static final String PARAMETER_COLUMN_VALUE = "Parameter";
    public static final int COLUMN_PARAMETER = 0;
    public static final int COLUMN_VALUE = 1;
    private static final int ORIGINAL_PARAMETER_NAME = 0;
    private static final int ORIGINAL_PARAMETER_VALUE = 1;
    private String[][] originalValues;
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public SetRapidminerParameters(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    public void doWork() throws OperatorException {
        super.doWork();
        this.setValues();
        this.dummyPorts.passDataThrough();
    }

    public void setValues() throws OperatorException {
        List param_rows = this.getParameterList(PARAMETER_TO_BE_CHANGED);
        this.originalValues = new String[param_rows.size()][2];
        Iterator i = param_rows.iterator();
        int valueCounter = 0;
        while (i.hasNext()) {
            String[] parameter = (String[])i.next();
            String operatorName = parameter[0];
            String value = parameter[1].toLowerCase();
            ParameterTypeParameterInternal.OperatorParameterInternalSelection selection = new ParameterTypeParameterInternal.OperatorParameterInternalSelection(operatorName);
            String name = selection.getParameterName();
            String originalValue = ParameterService.getParameterValue((String)name);
            this.originalValues[valueCounter][0] = name;
            this.originalValues[valueCounter][1] = originalValue;
            ParameterService.setParameterValue((String)name, (String)value);
        }
    }

    public void processFinished() throws OperatorException {
        super.processFinished();
        for (int valueCounter = this.originalValues.length - 1; valueCounter >= 0; --valueCounter) {
            String name = this.originalValues[valueCounter][0];
            String originaleValue = this.originalValues[valueCounter][1];
            ParameterService.setParameterValue((String)name, (String)originaleValue);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_TO_BE_CHANGED, "List of key value pairs where the key is the internal parameter name and the value specifies the value to be set.", (ParameterType)new ParameterTypeParameterInternal(PARAMETER_COLUMN_VALUE, "The name of the internal parameter."), (ParameterType)new ParameterTypeString(PARAMETER_COLUMN_NAME, "The name of the new value."));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

