/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.tools.ParameterTypeParameter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;
import java.util.logging.Level;

public class SetOperatorParameters
extends Operator {
    public static final String PARAMETER_TO_BE_SET = "parameter_to_set";
    public static final String PARAMETER_VALUE = "parameter_value";
    public static final String PARAMETER_COLUMN_NAME = "Value";
    public static final String PARAMETER_COLUMN_VALUE = "Operator_and_parameter";
    public static final String SEPARATOR = ".";
    public static final int COLUMN_PARAMETER = 0;
    public static final int COLUMN_VALUE = 1;
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public SetOperatorParameters(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    public void doWork() throws OperatorException {
        super.doWork();
        this.setValues();
        this.dummyPorts.passDataThrough();
    }

    public void setValues() throws OperatorException {
        List param_rows = this.getParameterList(PARAMETER_TO_BE_SET);
        for (String[] parameter : param_rows) {
            String categoryRange;
            String operatorName = parameter[0];
            String value = parameter[1].toLowerCase();
            ParameterTypeParameter.OperatorParameterSelection selection = ParameterTypeParameter.transformString2OperatorValueSelection(operatorName);
            Operator operator = this.getProcess().getOperator(selection.getOperator());
            String name = selection.isValue() ? selection.getValueName() : selection.getParameterName();
            ParameterType parameterType = operator.getParameterType(name);
            boolean stop = false;
            String stopMessage = "";
            if (parameterType.getClass() == ParameterTypeBoolean.class) {
                if (!value.equals("true") && !value.equals("false")) {
                    stop = true;
                    stopMessage = "Boolean parameter " + selection.getOperator() + SEPARATOR + name + " can not be set to " + value + ", but to 'true' or 'false'.";
                }
            } else if (parameterType.getClass() == ParameterTypeCategory.class && (categoryRange = operator.getParameterType(name).getRange().toLowerCase()).indexOf(value) == -1) {
                stop = true;
                stopMessage = "Category parameter " + selection.getOperator() + SEPARATOR + name + " can not be set to " + value + SEPARATOR;
            }
            if (stop) {
                this.getLogger().logp(Level.WARNING, ((Object)((Object)this)).getClass().toString(), "createDataTable()", stopMessage);
                continue;
            }
            operator.setParameter(name, value);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_TO_BE_SET, "List of key value pairs where the key is the operator and parameter name and the value specifies the value to be set.", (ParameterType)new ParameterTypeParameter(PARAMETER_COLUMN_VALUE, "OPERATORNAME.[value|parameter].VALUE_NAME"), (ParameterType)new ParameterTypeString(PARAMETER_COLUMN_NAME, "The name of the operator and parameter."));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

