package de.dwds.ddc.client.main;

import de.dwds.ddc.client.*;

/** simple request tester class using DDCSocket */
public class DDCRequest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		//-- parse command-line
		if (args.length < 3) {
			System.err.println("Usage: java de.dwds.ddc.client.main.DDCRequest SERVER PORT REQUEST");
			System.exit(1);
		}
		String ddcHost = args[0];
		int    ddcPort = Integer.parseInt(args[1]);
		byte[] request = args[2].getBytes();
		
		try {
			//-- connect a DDC socket & send user request			
			DDCSocket dsock = new DDCSocket(ddcHost, ddcPort);
			dsock.setTimeout(5000); //-- 5 second timeout

			byte[] rsp = dsock.request(request);
			System.out.write(rsp);
			
			dsock.close();
		} catch (Exception e) {
			System.err.println("Exception: " + e.toString());
			e.printStackTrace();
			System.exit(2);
		}

	}

}
