/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.pam;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.pam.PAMModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class PAMOperator
extends Operator {
    protected final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    protected final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    protected final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    protected final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    protected final OutputPort classWeightsOutput = (OutputPort)this.getOutputPorts().createPort("class weights");
    public static final String PARAMETER_SHRINKAGE = "shrinkage";

    public PAMOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.modelOutput, PredictionModel.class));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.classWeightsOutput, IOObjectCollection.class));
    }

    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        double shrinkage = this.getParameterAsDouble(PARAMETER_SHRINKAGE);
        PAMModel model = new PAMModel(exampleSet, shrinkage);
        this.modelOutput.deliver((IOObject)model);
        this.exampleSetOutput.deliver((IOObject)exampleSet);
        this.weightsOutput.deliver((IOObject)model.getWeights());
        this.classWeightsOutput.deliver(model.getClassWeights());
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_SHRINKAGE, "Shrinkage for soft thresholding of centroids.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        return types;
    }
}

