/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.mrmr.MIDCriterion;
import com.rapidminer.operator.mrmr.MIQCriterion;
import com.rapidminer.operator.mrmr.MRMRCache;
import com.rapidminer.operator.mrmr.RedundancyCriterion;
import com.rapidminer.operator.mrmr.RelevanceCriterion;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.List;

public class MRMRFeatureSetEvaluator
extends Operator {
    public static String PARAMETER_METHOD = "criteria_combination_method";
    public static final String[] METHODS = new String[]{"Multi criteria", "Difference", "Quotient"};
    public static final int METHOD_MULTI = 0;
    public static final int METHOD_DIFFERENCE = 1;
    public static final int METHOD_QUOTIENT = 2;
    public static String PARAMETER_ALPHA = "alpha";
    public double relevance = 0.0;
    public double redundancy = 0.0;
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final InputPort cacheInput = this.getInputPorts().createPort("cache", MRMRCache.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private final OutputPort cacheOutput = (OutputPort)this.getOutputPorts().createPassThroughPort("cache");

    public MRMRFeatureSetEvaluator(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("relevance", "The average relevance of all regular attributes concerning the label."){

            public double getDoubleValue() {
                return MRMRFeatureSetEvaluator.this.relevance;
            }
        });
        this.addValue((Value)new ValueDouble("redundancy", "The redundancy among all regular attributes."){

            public double getDoubleValue() {
                return MRMRFeatureSetEvaluator.this.redundancy;
            }
        });
        this.getTransformer().addRule((MDTransformationRule)new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, true));
        this.getTransformer().addRule((MDTransformationRule)new PassThroughRule(this.cacheInput, this.cacheOutput, false));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.performanceOutput, PerformanceVector.class));
    }

    public void doWork() throws OperatorException {
        this.inApplyLoop();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        PerformanceVector performance = new PerformanceVector();
        MRMRCache cache = null;
        if (this.cacheInput.isConnected()) {
            cache = (MRMRCache)this.cacheInput.getData();
        }
        RelevanceCriterion crit_relevance = new RelevanceCriterion(cache);
        crit_relevance.startCounting(exampleSet, true);
        this.relevance = crit_relevance.getFitness();
        RedundancyCriterion crit_redundancy = new RedundancyCriterion(cache);
        crit_redundancy.startCounting(exampleSet, true);
        this.redundancy = crit_redundancy.getFitness();
        switch (this.getParameterAsInt(PARAMETER_METHOD)) {
            case 0: {
                performance.addCriterion((PerformanceCriterion)crit_relevance);
                performance.addCriterion((PerformanceCriterion)crit_redundancy);
                break;
            }
            case 1: {
                double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
                if (alpha >= 0.0 && alpha <= 1.0) {
                    performance.addCriterion((PerformanceCriterion)new MIDCriterion(this.relevance, -this.redundancy, alpha));
                    break;
                }
                performance.addCriterion((PerformanceCriterion)new MIDCriterion(this.relevance, -this.redundancy));
                break;
            }
            case 2: {
                performance.addCriterion((PerformanceCriterion)new MIQCriterion(this.relevance, -this.redundancy));
            }
        }
        this.performanceOutput.deliver((IOObject)performance);
        this.exampleSetOutput.deliver((IOObject)exampleSet);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_METHOD, "How to combine relevance and redundancy. Multicrit, MID or MIQ", METHODS, 0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha for weighted combination of relevance and redundancy. A value < 0 means don't use alpha.", -1.0, 1.0, -1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, METHODS, false, new int[]{1}));
        types.add(type);
        return types;
    }
}

