/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Example;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class MIQCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -5343958353990535895L;
    protected double miq = 0.0;
    protected double counter = 1.0;

    public MIQCriterion() {
    }

    public MIQCriterion(double rel, double red) {
        this.miq = red != 0.0 ? rel / red : rel / 1000.0;
    }

    public MIQCriterion(MIQCriterion rc) {
        super((MeasuredPerformance)rc);
        this.miq = rc.miq;
        this.counter = rc.counter;
    }

    public String getName() {
        return "mutual_information_quotient";
    }

    public String getDescription() {
        return "Relevance / Redundancy";
    }

    public double getComparisonCount() {
        return this.counter;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        return this.miq;
    }

    public double getMikroAverage() {
        return this.miq;
    }

    public double getExampleCount() {
        return this.counter;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable averagable) {
        try {
            MIQCriterion other = (MIQCriterion)averagable;
            this.miq += other.miq;
            this.counter += other.counter;
        }
        catch (Exception e) {
            this.log("Could not build average because of casting error.");
        }
    }
}

