/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mrmr;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.mrmr.MRMRCache;
import com.rapidminer.operator.mrmr.MRMRFunctions;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public abstract class AbstractMRMRCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -5019434654348454895L;
    public static final String[] DIRECTIONS = new String[]{"minimization", "maximization"};
    public static final int MINIMIZATION = 0;
    public static final int MAXIMIZATION = 1;
    protected double information_value;
    protected double counter = 1.0;
    protected int direction = 0;
    protected MRMRCache cache;

    public AbstractMRMRCriterion(MRMRCache cache) {
        this.cache = cache;
    }

    public AbstractMRMRCriterion(int direction, MRMRCache cache) {
        this.cache = cache;
        this.direction = direction;
    }

    public AbstractMRMRCriterion(AbstractMRMRCriterion rc, MRMRCache cache) {
        super((MeasuredPerformance)rc);
        this.information_value = rc.information_value;
        this.counter = rc.counter;
        this.direction = rc.direction;
        this.cache = cache;
    }

    public String getName() {
        return "redundancy_of_attributes";
    }

    public String getDescription() {
        return "Measures redundancy of all attributes in the example set.";
    }

    public double getComparisonCount() {
        return this.counter;
    }

    public void countExample(Example example) {
    }

    public double getFitness() {
        switch (this.direction) {
            case 0: {
                return -1.0 * this.information_value;
            }
            case 1: {
                return this.information_value;
            }
        }
        return 0.0;
    }

    public double getMikroAverage() {
        return this.information_value;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void buildSingleAverage(Averagable averagable) {
        try {
            AbstractMRMRCriterion other = (AbstractMRMRCriterion)averagable;
            this.information_value += other.information_value;
            this.counter += other.counter;
        }
        catch (Exception e) {
            this.log("Could not build average because of casting error.");
        }
    }

    protected double GetInformationValue_Num_Num(ExampleSet exampleset, Attribute x, Attribute y) {
        return Math.abs(MRMRFunctions.Correlation(exampleset, x, y));
    }

    protected double GetInformationValue_Num_Nom(ExampleSet exampleset, Attribute num_var, Attribute nom_var) {
        return MRMRFunctions.FTest(exampleset, num_var, nom_var);
    }

    protected double GetInformationValue_Nom_Nom(ExampleSet exampleset, Attribute x, Attribute y) {
        try {
            return Math.abs(MRMRFunctions.MutualInformation(exampleset, x, y));
        }
        catch (OperatorException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getExampleCount() {
        return this.counter;
    }
}

