/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.List;

public class TopK
extends Operator {
    public static final String PARAMETER_WEIGHT = "weight";
    public static final String PARAMETER_WEIGHT_RELATION = "weight_relation";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_P = "p";
    private static final String[] WEIGHT_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less", "top k", "bottom k", "all but top k", "all but bottom k", "top p%", "bottom p%"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private static final int TOPK = 5;
    private static final int BOTTOMK = 6;
    private static final int ALLBUTTOPK = 7;
    private static final int ALLBUTBOTTOMK = 8;
    private static final int TOPPPERCENT = 9;
    private static final int BOTTOMPPERCENT = 10;
    private InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public static final String PARAMETER_INVERSE = "inverse";
    public static final String PARAMETER_ABSOLUTE = "absolute weights";

    public TopK(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.weightsInput, this.weightsOutput);
    }

    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        boolean inverse = this.getParameterAsBoolean(PARAMETER_INVERSE);
        boolean absolute = this.getParameterAsBoolean(PARAMETER_ABSOLUTE);
        double relationWeight = this.getParameterAsDouble(PARAMETER_WEIGHT);
        int relation = this.getParameterAsInt(PARAMETER_WEIGHT_RELATION);
        boolean useAbsoluteWeights = this.getParameterAsBoolean(PARAMETER_ABSOLUTE);
        boolean index = false;
        int nrAtts = weights.size();
        int k = this.getParameterAsInt(PARAMETER_K);
        if (relation == 7) {
            relation = 6;
            k = nrAtts - k;
        }
        if (relation == 8) {
            relation = 5;
            k = nrAtts - k;
        }
        if (relation == 9) {
            relation = 5;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (relation == 10) {
            relation = 6;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (k < 1) {
            k = 1;
        }
        if (k > nrAtts) {
            k = nrAtts;
        }
        String[] attributeNames = new String[nrAtts];
        attributeNames = weights.getAttributeNames().toArray(attributeNames);
        index = false;
        if (relation == 5 || relation == 6) {
            int i;
            int direction = -1;
            if (relation == 6) {
                direction = 1;
            }
            int comparatorType = 0;
            if (useAbsoluteWeights) {
                comparatorType = 1;
            }
            weights.sortByWeight(attributeNames, direction, comparatorType);
            for (i = 0; i < k; ++i) {
                weights.setWeight(attributeNames[i], 1.0);
            }
            for (i = k; i < nrAtts; ++i) {
                weights.setWeight(attributeNames[i], 0.0);
            }
        } else {
            for (int i = 0; i < nrAtts; ++i) {
                double weight = weights.getWeight(attributeNames[i]);
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                switch (relation) {
                    case 0: {
                        if (weight <= relationWeight) {
                            weight = 0.0;
                            break;
                        }
                        weight = 1.0;
                        break;
                    }
                    case 1: {
                        if (weight < relationWeight) {
                            weight = 0.0;
                            break;
                        }
                        weight = 1.0;
                        break;
                    }
                    case 2: {
                        if (weight != relationWeight) {
                            weight = 0.0;
                            break;
                        }
                        weight = 1.0;
                        break;
                    }
                    case 3: {
                        if (weight > relationWeight) {
                            weight = 0.0;
                            break;
                        }
                        weight = 1.0;
                        break;
                    }
                    case 4: {
                        weight = weight >= relationWeight ? 0.0 : 1.0;
                    }
                }
                weights.setWeight(attributeNames[i], weight);
            }
        }
        this.weightsOutput.deliver((IOObject)weights);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_WEIGHT_RELATION, "Selects only weights which fulfill this relation.", WEIGHT_RELATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_WEIGHT, "The selected relation will be evaluated against this value.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, new int[]{0, 1, 4, 3, 2}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_K, "Number k of attributes to be selected. For example 'top k' with k = 5 will return an exampleset containing only the 5 highest weighted attributes.", 1, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, new int[]{5, 6, 8, 7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P, "Percentage of attributes to be selected. For example 'top p%' with p = 15 will return an exampleset containing only attributes which are part of the 15% of the highest weighted attributes.", 0.0, 1.0, 0.5);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, new int[]{9, 10}));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_ABSOLUTE, "Indicates if the absolute values of the weights should be used for comparison.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_ABSOLUTE, "Use absolute weights.", false));
        return types;
    }
}

