/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.mfs.Util;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

public class FeatureSelectionStabilityEvaluator
extends OperatorChain {
    protected final InputPort exampleSetInput = this.getInputPorts().createPort("exampleset", ExampleSet.class);
    protected final OutputPort weightingProcessExampleSetOutput = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("exampleset");
    protected final InputPort weightingProcessWeightsInput = this.getSubprocess(0).getInnerSinks().createPort("weights", AttributeWeights.class);
    protected final OutputPort robustnessOutput = (OutputPort)this.getOutputPorts().createPort("robustness");
    protected final OutputPort kunchevaOutput = (OutputPort)this.getOutputPorts().createPort("kuncheva");
    protected final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exampleset");
    protected int iteration = 0;
    public static final String PARAMETER_MEASURE = "measure";
    public static final String[] METHODS = new String[]{"sets", "weights", "ranks"};
    public static final int METHOD_SETS = 0;
    public static final int METHOD_WEIGHTS = 1;
    public static final int METHOD_RANKS = 2;
    public static final String PARAMETER_BOOTSTRAP_OR_SUBSETS = "subsets_or_bootstrap";
    public static final String[] BOOTSTRAP_OR_SUBSETS = new String[]{"subsets", "bootstrap"};
    public static final int SUBSET = 0;
    public static final int BOOTSTRAP = 1;
    public static final String PARAMETER_BOOTSTRAP_RATIO = "ratio";
    public static final String PARAMETER_REPETITIONS = "repetitions";
    public static final String PARAMETER_LEAVE_ONE_OUT = "leave_one_out";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private double robustness = 0.0;
    private double kuncheva = 0.0;

    public FeatureSelectionStabilityEvaluator(OperatorDescription description) {
        super(description, new String[]{"Weighting"});
        this.addValue((Value)new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return FeatureSelectionStabilityEvaluator.this.iteration;
            }
        });
        this.addValue((Value)new ValueDouble("robustness", "Robustness of the inner Feature Selection operator"){

            public double getDoubleValue() {
                return FeatureSelectionStabilityEvaluator.this.robustness;
            }
        });
        this.addValue((Value)new ValueDouble("consistency", "Consistency index according to Kuncheva 2007 \"A Stability Index for feature selection\""){

            public double getDoubleValue() {
                return FeatureSelectionStabilityEvaluator.this.kuncheva;
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
    }

    public void doWork() throws OperatorException {
        this.iteration = 0;
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        boolean doTheBootstrap = this.getParameterAsInt(PARAMETER_BOOTSTRAP_OR_SUBSETS) == 1;
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        int repetitions = !doTheBootstrap && this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT) ? inputSet.size() : this.getParameterAsInt(PARAMETER_REPETITIONS);
        AttributeWeights[] weights = new AttributeWeights[repetitions];
        if (doTheBootstrap) {
            RandomGenerator random = RandomGenerator.getRandomGenerator((Operator)this);
            this.iteration = 0;
            while (this.iteration < repetitions) {
                this.inApplyLoop();
                int[] mapping = MappedExampleSet.createBootstrappingMapping((ExampleSet)inputSet, (int)((int)Math.round((double)inputSet.size() * this.getParameterAsDouble(PARAMETER_BOOTSTRAP_RATIO))), (Random)random);
                MappedExampleSet bootstrappedExampleSet = new MappedExampleSet(inputSet, mapping, true);
                this.weightingProcessExampleSetOutput.deliver((IOObject)bootstrappedExampleSet);
                this.getSubprocess(0).execute();
                weights[this.iteration] = (AttributeWeights)this.weightingProcessWeightsInput.getData();
                ++this.iteration;
            }
        } else {
            SplittedExampleSet splitES = new SplittedExampleSet(inputSet, repetitions, samplingType, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
            this.iteration = 0;
            while (this.iteration < repetitions) {
                this.inApplyLoop();
                splitES.selectAllSubsetsBut(this.iteration);
                this.weightingProcessExampleSetOutput.deliver((IOObject)splitES);
                this.getSubprocess(0).execute();
                weights[this.iteration] = (AttributeWeights)this.weightingProcessWeightsInput.getData();
                ++this.iteration;
            }
        }
        String[] attributenames = Util.getAttributeNames(inputSet);
        for (int i = 0; i < repetitions; ++i) {
            if (weights[i].getSize() >= attributenames.length) continue;
            double kevin = 0.0;
            AttributeWeights temp_w = new AttributeWeights(inputSet);
            for (String attName : attributenames) {
                kevin = weights[i].getWeight(attName);
                if (Double.isNaN(kevin)) {
                    temp_w.setWeight(attName, 0.0);
                    continue;
                }
                temp_w.setWeight(attName, kevin);
            }
            weights[i] = temp_w;
            this.getLogger().finest("[FS-Stability-Evaluator] The " + i + "th round produced less weights than needed. Set missing weights to 0.");
        }
        int measure = this.getParameterAsInt(PARAMETER_MEASURE);
        if (measure == 0) {
            double[] temp = Util.averageRobustness(attributenames, weights);
            this.robustness = temp[0];
            this.kuncheva = temp[1];
        } else {
            this.robustness = measure == 1 ? Util.averagePearsonCorrelation(attributenames, weights, repetitions) : (measure == 2 ? -1000.0 : 0.0);
        }
        this.getLogger().finest("Robustness of the ensemble feature selection: " + this.robustness);
        PerformanceVector pvector = new PerformanceVector();
        EstimatedPerformance criterion = new EstimatedPerformance("Robustness", this.robustness, inputSet.size(), false);
        pvector.addCriterion((PerformanceCriterion)criterion);
        pvector.setMainCriterionName("Robustness");
        PerformanceVector pvector_kuncheva = new PerformanceVector();
        EstimatedPerformance criterion_kuncheva = new EstimatedPerformance("Consistency", this.kuncheva, inputSet.size(), false);
        pvector_kuncheva.addCriterion((PerformanceCriterion)criterion_kuncheva);
        pvector_kuncheva.setMainCriterionName("Consistency");
        this.exampleSetOutput.deliver((IOObject)inputSet);
        this.robustnessOutput.deliver((IOObject)pvector);
        this.kunchevaOutput.deliver((IOObject)pvector_kuncheva);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_REPETITIONS, "Number of repetitions / folds in the XV", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_MEASURE, "Which measure to use for measuring selection robustness.", METHODS, 0);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_BOOTSTRAP_OR_SUBSETS, "Use subsets or bootstraps to generate ensemble diversity.", BOOTSTRAP_OR_SUBSETS, 0));
        type = new ParameterTypeDouble(PARAMETER_BOOTSTRAP_RATIO, "Relative size of the bootstrapped example sets.", 1.0E-4, 1.0, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{1}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LEAVE_ONE_OUT, "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LEAVE_ONE_OUT, false, false));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LEAVE_ONE_OUT, false, false));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SAMPLING_TYPE, SplittedExampleSet.SAMPLING_NAMES, false, new int[]{1, 2}));
        types.add(type);
        return types;
    }

    public static enum Method {
        Subset,
        Average;

    }
}

