/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;

public class ExonTTest
extends AbstractWeighting {
    public ExonTTest(OperatorDescription operatordescription) {
        super(operatordescription);
    }

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        this.setParameter("normalize_weights", "false");
        this.setParameter("sort_weights", "false");
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.getMapping().getValues().size() != 2) {
            throw new OperatorException("Welch-test only applicable for two-class problems.");
        }
        AttributeWeights pValueWeights = new AttributeWeights(exampleSet);
        String[] attributeNames = new String[pValueWeights.getAttributeNames().size()];
        attributeNames = pValueWeights.getAttributeNames().toArray(attributeNames);
        int d = exampleSet.getAttributes().size();
        int n = exampleSet.size();
        double[] labelsExamples = new double[n];
        double[] sumX = new double[d];
        double[] sumY = new double[d];
        double[] sumXX = new double[d];
        double[] sumYY = new double[d];
        int i = 0;
        double nX = 0.0;
        double nY = 0.0;
        int posLabelIndex = label.getMapping().getPositiveIndex();
        Iterator iterator = exampleSet.iterator();
        while (iterator.hasNext()) {
            double label2;
            labelsExamples[i] = label2 = ((Example)iterator.next()).getLabel();
            if (label2 == (double)posLabelIndex) {
                nX += 1.0;
            } else {
                nY += 1.0;
            }
            ++i;
        }
        if (nX == 0.0) {
            throw new UserError((Operator)this, 105, new Object[]{"Positive class contains no examples."});
        }
        if (nY == 0.0) {
            throw new UserError((Operator)this, 105, new Object[]{"Negative class contains no examples."});
        }
        for (i = 0; i < d; ++i) {
            sumX[i] = 0.0;
            sumY[i] = 0.0;
            sumXX[i] = 0.0;
            sumYY[i] = 0.0;
        }
        int j = 0;
        for (Example example : exampleSet) {
            i = 0;
            for (Attribute att : exampleSet.getAttributes()) {
                double value = example.getValue(att);
                if (labelsExamples[j] == (double)posLabelIndex) {
                    int n2 = i;
                    sumX[n2] = sumX[n2] + value;
                    int n3 = i;
                    sumXX[n3] = sumXX[n3] + value * value;
                } else {
                    int n4 = i;
                    sumY[n4] = sumY[n4] + value;
                    int n5 = i;
                    sumYY[n5] = sumYY[n5] + value * value;
                }
                ++i;
            }
            ++j;
        }
        double v = nX + nY - 2.0;
        TDistributionImpl dist = new TDistributionImpl(v);
        double denomT = Math.sqrt(nX * nY / (nX + nY));
        i = 0;
        for (Attribute att : exampleSet.getAttributes()) {
            double cum2;
            double cum1;
            double meanX = sumX[i] / nX;
            double meanY = sumY[i] / nY;
            double s = Math.sqrt((sumXX[i] - sumX[i] * sumX[i] / nX + (sumYY[i] - sumY[i] * sumY[i] / nY)) / v);
            double t = Math.abs((meanX - meanY) / s * denomT);
            try {
                cum1 = dist.cumulativeProbability(t);
            }
            catch (MathException e) {
                cum1 = 0.0;
                e.printStackTrace();
            }
            try {
                cum2 = dist.cumulativeProbability(-t);
            }
            catch (MathException e) {
                cum2 = 0.0;
                e.printStackTrace();
            }
            double p = 1.0 - (cum1 - cum2);
            pValueWeights.setWeight(att.getName(), p);
            ++i;
        }
        pValueWeights.setSource(this.getName());
        return pValueWeights;
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>(0);
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return capability != OperatorCapability.NUMERICAL_LABEL && capability != OperatorCapability.BINOMINAL_ATTRIBUTES && capability != OperatorCapability.POLYNOMINAL_LABEL && capability != OperatorCapability.POLYNOMINAL_ATTRIBUTES;
    }
}

