/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.lasso;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.lasso.LARSModel;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class LARSLearner
extends AbstractLearner {
    protected final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public static final String PARAMETER_LASSO = "lasso";
    public static final String PARAMETER_T = "t";
    public static final String PARAMETER_EPSILON = "epsilon";
    private LARSModel model;

    public LARSLearner(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.model = new LARSModel(exampleSet, this.getParameterAsBoolean(PARAMETER_LASSO), this.getParameterAsDouble(PARAMETER_T), this.getParameterAsDouble(PARAMETER_EPSILON));
        this.weightsOutput.deliver((IOObject)this.model.getWeights());
        return this.model;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_LASSO, "Calculates LASSO-estimates.", true));
        types.add(new ParameterTypeDouble(PARAMETER_T, "LASSO threshold", 0.0, Double.MAX_VALUE, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Convergence epsilon", 0.0, Double.MAX_VALUE, 0.001, true));
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        return capability == OperatorCapability.NUMERICAL_ATTRIBUTES || capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_LABEL || capability == OperatorCapability.WEIGHTED_EXAMPLES;
    }
}

