/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.fcbf;

import com.rapidminer.example.Attribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FCBFAttributeLabel {
    protected Attribute attribute;
    protected double entropy;
    protected Vector<Integer> discretizedValues;
    protected Map<Integer, Double> pmf;

    public FCBFAttributeLabel(Attribute attribute, Vector<Integer> discretizedValues) {
        this.attribute = attribute;
        this.discretizedValues = discretizedValues;
        this.pmf = new HashMap<Integer, Double>();
        int discretizedValuesSize = discretizedValues.size();
        for (int i = 0; i < discretizedValuesSize; ++i) {
            int key = discretizedValues.get(i);
            if (this.pmf.containsKey(key)) {
                this.pmf.put(key, this.pmf.get(key) + 1.0);
                continue;
            }
            this.pmf.put(key, 1.0);
        }
        this.entropy = 0.0;
        for (Map.Entry<Integer, Double> entry : this.pmf.entrySet()) {
            int key = entry.getKey();
            double value = entry.getValue() / (double)discretizedValuesSize;
            this.pmf.put(key, value);
            this.entropy -= value * Math.log10(value) / Math.log10(2.0);
        }
    }
}

