/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.bahsic;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.bahsic.BAHSICFeatureSelector;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelAnova;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelDot;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelEpanechnikov;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelGaussianCombination;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelMultiquadric;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelNeural;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelPolynomial;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelRadial;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.value.ParameterValueGrid;
import java.util.List;
import java.util.Vector;

public class BAHSICOperator
extends Operator {
    protected final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    protected final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    protected final OutputPort exampleSetBestOutput = (OutputPort)this.getOutputPorts().createPort("example set best");
    protected final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public static final String PARAMETER_KERNELX_TYPE = "kernelx_type";
    public static final String PARAMETER_KERNELX_GAMMA = "kernelx_gamma";
    public static final String PARAMETER_KERNELX_SIGMA1 = "kernelx_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA2 = "kernelx_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA3 = "kernelx_sigma3";
    public static final String PARAMETER_KERNELX_SHIFT = "kernelx_shift";
    public static final String PARAMETER_KERNELX_DEGREE = "kernelx_degree";
    public static final String PARAMETER_KERNELX_A = "kernelx_a";
    public static final String PARAMETER_KERNELX_B = "kernelx_b";
    public static final String PARAMETER_KERNELX_CACHE = "kernelx_cache";
    public static final String PARAMETER_KERNELY_TYPE = "kernely_type";
    public static final String PARAMETER_KERNELY_GAMMA = "kernely_gamma";
    public static final String PARAMETER_KERNELY_SIGMA1 = "kernely_sigma1";
    public static final String PARAMETER_KERNELY_SIGMA2 = "kernely_sigma2";
    public static final String PARAMETER_KERNELY_SIGMA3 = "kernely_sigma3";
    public static final String PARAMETER_KERNELY_SHIFT = "kernely_shift";
    public static final String PARAMETER_KERNELY_DEGREE = "kernely_degree";
    public static final String PARAMETER_KERNELY_A = "kernely_a";
    public static final String PARAMETER_KERNELY_B = "kernely_b";
    public static final String PARAMETER_KERNELY_CACHE = "kernely_cache";
    public static final String PARAMETER_DESIRED_FEATURES = "desired_features";
    public static final String PARAMETER_FRACTION_ELIMINATED = "fraction_eliminated";
    public static final String PARAMETER_KERNELX_GAMMA_OPTIMIZE = "optimize_gamma";
    public static final String PARAMETER_KERNELX_GAMMA_MIN = "min_gamma";
    public static final String PARAMETER_KERNELX_GAMMA_MAX = "max_gamma";
    public static final String PARAMETER_KERNELX_GAMMA_STEP = "step_gamma";
    public static final String PARAMETER_KERNELX_GAMMA_SCALE = "scale_gamma";
    public static final String PARAMETER_KERNELX_SIGMA1_OPTIMIZE = "optimize_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA1_MIN = "min_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA1_MAX = "max_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA1_STEP = "step_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA1_SCALE = "scale_sigma1";
    public static final String PARAMETER_KERNELX_SIGMA2_OPTIMIZE = "optimize_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA2_MIN = "min_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA2_MAX = "max_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA2_STEP = "step_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA2_SCALE = "scale_sigma2";
    public static final String PARAMETER_KERNELX_SIGMA3_OPTIMIZE = "optimize_sigma3";
    public static final String PARAMETER_KERNELX_SIGMA3_MIN = "min_sigma3";
    public static final String PARAMETER_KERNELX_SIGMA3_MAX = "max_sigma3";
    public static final String PARAMETER_KERNELX_SIGMA3_STEP = "step_sigma3";
    public static final String PARAMETER_KERNELX_SIGMA3_SCALE = "scale_sigma3";
    public static final String PARAMETER_KERNELX_SHIFT_OPTIMIZE = "optimize_shift";
    public static final String PARAMETER_KERNELX_SHIFT_MIN = "min_shift";
    public static final String PARAMETER_KERNELX_SHIFT_MAX = "max_shift";
    public static final String PARAMETER_KERNELX_SHIFT_STEP = "step_shift";
    public static final String PARAMETER_KERNELX_SHIFT_SCALE = "scale_shift";
    public static final String PARAMETER_KERNELX_DEGREE_OPTIMIZE = "optimize_degree";
    public static final String PARAMETER_KERNELX_DEGREE_MIN = "min_degree";
    public static final String PARAMETER_KERNELX_DEGREE_MAX = "max_degree";
    public static final String PARAMETER_KERNELX_DEGREE_STEP = "step_degree";
    public static final String PARAMETER_KERNELX_DEGREE_SCALE = "scale_degree";
    public static final String PARAMETER_KERNELX_A_OPTIMIZE = "optimize_a";
    public static final String PARAMETER_KERNELX_A_MIN = "min_a";
    public static final String PARAMETER_KERNELX_A_MAX = "max_a";
    public static final String PARAMETER_KERNELX_A_STEP = "step_a";
    public static final String PARAMETER_KERNELX_A_SCALE = "scale_a";
    public static final String PARAMETER_KERNELX_B_OPTIMIZE = "optimize_b";
    public static final String PARAMETER_KERNELX_B_MIN = "min_b";
    public static final String PARAMETER_KERNELX_B_MAX = "max_b";
    public static final String PARAMETER_KERNELX_B_STEP = "step_b";
    public static final String PARAMETER_KERNELX_B_SCALE = "scale_b";
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "neural", "anova", "epachnenikov", "gaussian_combination", "multiquadric"};
    public static final Integer[] PARAMETER_COUNT = new Integer[]{0, 1, 1, 2, 2, 2, 3, 2};
    public static final String[] SCALE_TYPES = new String[]{"linear", "quadratic", "logarithmic", "logarithmic (legacy)"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_NEURAL = 3;
    public static final int KERNEL_ANOVA = 4;
    public static final int KERNEL_EPANECHNIKOV = 5;
    public static final int KERNEL_GAUSSIAN_COMBINATION = 6;
    public static final int KERNEL_MULTIQUADRIC = 7;

    public BAHSICOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exampleSetBestOutput, ExampleSet.class));
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
    }

    public void doWork() throws OperatorException {
        KernelDot kernely;
        KernelDot kernelx;
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Vector<Vector<Double>> parameterValuesOptimization = new Vector<Vector<Double>>();
        boolean optimize = false;
        int kernelxType = this.getParameterAsInt(PARAMETER_KERNELX_TYPE);
        switch (kernelxType) {
            case 0: {
                kernelx = new KernelDot();
                break;
            }
            case 1: {
                kernelx = new KernelRadial();
                ((KernelRadial)kernelx).setGamma(this.getParameterAsDouble(PARAMETER_KERNELX_GAMMA));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_GAMMA_OPTIMIZE)) {
                    optimize = true;
                    ParameterValueGrid parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_GAMMA), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_MIN), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_MAX), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_STEP), this.getParameterAsInt(PARAMETER_KERNELX_GAMMA_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                Vector<Double> parameterValuesVector = new Vector<Double>();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_GAMMA));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 2: {
                kernelx = new KernelPolynomial();
                ((KernelPolynomial)kernelx).setDegree(this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_DEGREE_OPTIMIZE)) {
                    optimize = true;
                    ParameterValueGrid parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_DEGREE), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MIN), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MAX), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_STEP), this.getParameterAsInt(PARAMETER_KERNELX_DEGREE_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                Vector<Double> parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 3: {
                ParameterValueGrid parameterValues;
                Vector<Double> parameterValuesVector;
                kernelx = new KernelNeural();
                ((KernelNeural)kernelx).setParameters(this.getParameterAsDouble(PARAMETER_KERNELX_A), this.getParameterAsDouble(PARAMETER_KERNELX_B));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_A_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_A), this.getParameterAsString(PARAMETER_KERNELX_A_MIN), this.getParameterAsString(PARAMETER_KERNELX_A_MAX), this.getParameterAsString(PARAMETER_KERNELX_A_STEP), this.getParameterAsInt(PARAMETER_KERNELX_A_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_A));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_B_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_B), this.getParameterAsString(PARAMETER_KERNELX_B_MIN), this.getParameterAsString(PARAMETER_KERNELX_B_MAX), this.getParameterAsString(PARAMETER_KERNELX_B_STEP), this.getParameterAsInt(PARAMETER_KERNELX_B_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_B));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 4: {
                ParameterValueGrid parameterValues;
                Vector<Double> parameterValuesVector;
                kernelx = new KernelAnova();
                ((KernelAnova)kernelx).setParameters(this.getParameterAsDouble(PARAMETER_KERNELX_GAMMA), this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_GAMMA_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_GAMMA), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_MIN), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_MAX), this.getParameterAsString(PARAMETER_KERNELX_GAMMA_STEP), this.getParameterAsInt(PARAMETER_KERNELX_GAMMA_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_GAMMA));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_DEGREE_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_DEGREE), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MIN), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MAX), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_STEP), this.getParameterAsInt(PARAMETER_KERNELX_DEGREE_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 5: {
                ParameterValueGrid parameterValues;
                Vector<Double> parameterValuesVector;
                kernelx = new KernelEpanechnikov();
                ((KernelEpanechnikov)kernelx).setParameters(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SIGMA1_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SIGMA1), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MIN), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MAX), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SIGMA1_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_DEGREE_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_DEGREE), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MIN), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_MAX), this.getParameterAsString(PARAMETER_KERNELX_DEGREE_STEP), this.getParameterAsInt(PARAMETER_KERNELX_DEGREE_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_DEGREE));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 6: {
                ParameterValueGrid parameterValues;
                Vector<Double> parameterValuesVector;
                kernelx = new KernelGaussianCombination();
                ((KernelGaussianCombination)kernelx).setParameters(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA2), this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA3));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SIGMA1_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SIGMA1), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MIN), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MAX), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SIGMA1_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SIGMA2_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SIGMA2), this.getParameterAsString(PARAMETER_KERNELX_SIGMA2_MIN), this.getParameterAsString(PARAMETER_KERNELX_SIGMA2_MAX), this.getParameterAsString(PARAMETER_KERNELX_SIGMA2_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SIGMA2_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA2));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SIGMA3_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SIGMA3), this.getParameterAsString(PARAMETER_KERNELX_SIGMA3_MIN), this.getParameterAsString(PARAMETER_KERNELX_SIGMA3_MAX), this.getParameterAsString(PARAMETER_KERNELX_SIGMA3_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SIGMA3_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA3));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            case 7: {
                ParameterValueGrid parameterValues;
                Vector<Double> parameterValuesVector;
                kernelx = new KernelMultiquadric();
                ((KernelMultiquadric)kernelx).setParameters(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELX_SHIFT));
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SIGMA1_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SIGMA1), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MIN), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_MAX), this.getParameterAsString(PARAMETER_KERNELX_SIGMA1_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SIGMA1_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                } else {
                    parameterValuesVector = new Vector();
                    parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SIGMA1));
                    parameterValuesOptimization.add(parameterValuesVector);
                }
                if (this.getParameterAsBoolean(PARAMETER_KERNELX_SHIFT_OPTIMIZE)) {
                    optimize = true;
                    parameterValues = new ParameterValueGrid((Operator)this, this.getParameterType(PARAMETER_KERNELX_SHIFT), this.getParameterAsString(PARAMETER_KERNELX_SHIFT_MIN), this.getParameterAsString(PARAMETER_KERNELX_SHIFT_MAX), this.getParameterAsString(PARAMETER_KERNELX_SHIFT_STEP), this.getParameterAsInt(PARAMETER_KERNELX_SHIFT_SCALE));
                    parameterValuesOptimization.add(this.arrayStringToVectorDouble(parameterValues.getValuesArray()));
                    break;
                }
                parameterValuesVector = new Vector();
                parameterValuesVector.add(this.getParameterAsDouble(PARAMETER_KERNELX_SHIFT));
                parameterValuesOptimization.add(parameterValuesVector);
                break;
            }
            default: {
                kernelx = new KernelDot();
            }
        }
        int kernelyType = this.getParameterAsInt(PARAMETER_KERNELY_TYPE);
        switch (kernelyType) {
            case 0: {
                kernely = new KernelDot();
                break;
            }
            case 1: {
                kernely = new KernelRadial();
                ((KernelRadial)kernely).setGamma(this.getParameterAsDouble(PARAMETER_KERNELY_GAMMA));
                break;
            }
            case 2: {
                kernely = new KernelPolynomial();
                ((KernelPolynomial)kernely).setDegree(this.getParameterAsDouble(PARAMETER_KERNELY_DEGREE));
                break;
            }
            case 3: {
                kernely = new KernelNeural();
                ((KernelNeural)kernely).setParameters(this.getParameterAsDouble(PARAMETER_KERNELY_A), this.getParameterAsDouble(PARAMETER_KERNELY_B));
                break;
            }
            case 4: {
                kernely = new KernelAnova();
                ((KernelAnova)kernely).setParameters(this.getParameterAsDouble(PARAMETER_KERNELY_GAMMA), this.getParameterAsDouble(PARAMETER_KERNELY_DEGREE));
                break;
            }
            case 5: {
                kernely = new KernelEpanechnikov();
                ((KernelEpanechnikov)kernely).setParameters(this.getParameterAsDouble(PARAMETER_KERNELY_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELY_DEGREE));
                break;
            }
            case 6: {
                kernely = new KernelGaussianCombination();
                ((KernelGaussianCombination)kernely).setParameters(this.getParameterAsDouble(PARAMETER_KERNELY_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELY_SIGMA2), this.getParameterAsDouble(PARAMETER_KERNELY_SIGMA3));
                break;
            }
            case 7: {
                kernely = new KernelMultiquadric();
                ((KernelMultiquadric)kernely).setParameters(this.getParameterAsDouble(PARAMETER_KERNELY_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNELY_SHIFT));
                break;
            }
            default: {
                kernely = new KernelDot();
            }
        }
        int desiredFeatures = this.getParameterAsInt(PARAMETER_DESIRED_FEATURES);
        double fractionEliminated = this.getParameterAsDouble(PARAMETER_FRACTION_ELIMINATED);
        BAHSICFeatureSelector bahsicFeatureSelector = new BAHSICFeatureSelector(exampleSet, (Kernel)kernelx, kernelxType, (Kernel)kernely, kernelyType, desiredFeatures, fractionEliminated);
        bahsicFeatureSelector.setParametersToOptimize(parameterValuesOptimization, optimize);
        bahsicFeatureSelector.unbiasedBAHSIC();
        this.exampleSetOutput.deliver((IOObject)exampleSet);
        this.exampleSetBestOutput.deliver((IOObject)bahsicFeatureSelector.computeExampleSetBest());
        this.weightsOutput.deliver((IOObject)bahsicFeatureSelector.computeWeights());
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_KERNELX_TYPE, "The kernel type for the data", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_GAMMA, "The kernel(data) parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{1, 4}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_GAMMA_OPTIMIZE, "Indicates if optimization over parameter gamma is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{1, 4}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_GAMMA_MIN, "The minimum value for optimization of the kernel(data) parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_GAMMA_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_GAMMA_MAX, "The maximum value for optimization of the kernel(data) parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_GAMMA_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_GAMMA_STEP, "Number of steps for optimization of the kernel(data) parameter gamma.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_GAMMA_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_GAMMA_SCALE, "Grid scheme for optimization of the kernel(data) parameter gamma.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_GAMMA_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA1, "The kernel(data) parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{5, 6, 7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_SIGMA1_OPTIMIZE, "Indicates if optimization over parameter sigma1 is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{5, 6, 7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA1_MIN, "The minimum value for optimization of the kernel(data) parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA1_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA1_MAX, "The maximum value for optimization of the kernel(data) parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA1_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_SIGMA1_STEP, "Number of steps for optimization of the kernel(data) parameter sigma1.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA1_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_SIGMA1_SCALE, "Grid scheme for optimization of the kernel(data) parameter sigma1.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA1_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA2, "The kernel(data) parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_SIGMA2_OPTIMIZE, "Indicates if optimization over parameter sigma2 is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA2_MIN, "The minimum value for optimization of the kernel(data) parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA2_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA2_MAX, "The maximum value for optimization of the kernel(data) parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA2_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_SIGMA2_STEP, "Number of steps for optimization of the kernel(data) parameter sigma2.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA2_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_SIGMA2_SCALE, "Grid scheme for optimization of the kernel(data) parameter sigma2.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA2_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA3, "The kernel(data) parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_SIGMA3_OPTIMIZE, "Indicates if optimization over parameter sigma3 is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA3_MIN, "The minimum value for optimization of the kernel(data) parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA3_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SIGMA3_MAX, "The maximum value for optimization of the kernel(data) parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA3_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_SIGMA3_STEP, "Number of steps for optimization of the kernel(data) parameter sigma3.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA3_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_SIGMA3_SCALE, "Grid scheme for optimization of the kernel(data) parameter sigma3.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SIGMA3_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SHIFT, "The kernel(data) parameter shift.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_SHIFT_OPTIMIZE, "Indicates if optimization over parameter shift is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SHIFT_MIN, "The minimum value for optimization of the kernel(data) parameter shift.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SHIFT_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_SHIFT_MAX, "The maximum value for optimization of the kernel(data) parameter shift.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SHIFT_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_SHIFT_STEP, "Number of steps for optimization of the kernel(data) parameter shift.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SHIFT_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_SHIFT_SCALE, "Grid scheme for optimization of the kernel(data) parameter shift.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_SHIFT_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_DEGREE, "The kernel(data) parameter degree.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{2, 4, 5}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_DEGREE_OPTIMIZE, "Indicates if optimization over parameter degree is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{2, 4, 5}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_DEGREE_MIN, "The minimum value for optimization of the kernel(data) parameter degree.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_DEGREE_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_DEGREE_MAX, "The maximum value for optimization of the kernel(data) parameter degree.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_DEGREE_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_DEGREE_STEP, "Number of steps for optimization of the kernel(data) parameter degree.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_DEGREE_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_DEGREE_SCALE, "Grid scheme for optimization of the kernel(data) parameter degree.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_DEGREE_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_A, "The kernel(data) parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_A_OPTIMIZE, "Indicates if optimization over parameter a is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_A_MIN, "The minimum value for optimization of the kernel(data) parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_A_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_A_MAX, "The maximum value for optimization of the kernel(data) parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_A_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_A_STEP, "Number of steps for optimization of the kernel(data) parameter a.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_A_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_A_SCALE, "Grid scheme for optimization of the kernel(data) parameter a.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_A_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_B, "The kernel(data) parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KERNELX_B_OPTIMIZE, "Indicates if optimization over parameter b is required for the kernel(data)", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELX_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_B_MIN, "The minimum value for optimization of the kernel(data) parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_B_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELX_B_MAX, "The maximum value for optimization of the kernel(data) parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_B_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_KERNELX_B_STEP, "Number of steps for optimization of the kernel(data) parameter b.", 0, Integer.MAX_VALUE, 5);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_B_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELX_B_SCALE, "Grid scheme for optimization of the kernel(data) parameter b.", SCALE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KERNELX_B_OPTIMIZE, false, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNELY_TYPE, "The kernel type for the labels", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_GAMMA, "The kernel(labels) parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{1, 4}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_SIGMA1, "The kernel(labels) parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{5, 6, 7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_SIGMA2, "The kernel(labels) parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_SIGMA3, "The kernel(labels) parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{6}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_SHIFT, "The kernel(labels) parameter shift.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{7}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_DEGREE, "The kernel(labels) parameter degree.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{2, 4, 5}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_A, "The kernel(labels) parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNELY_B, "The kernel(labels) parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_KERNELY_TYPE, KERNEL_TYPES, false, new int[]{3}));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_DESIRED_FEATURES, "The number of desired features", 0, Integer.MAX_VALUE, 25));
        types.add(new ParameterTypeDouble(PARAMETER_FRACTION_ELIMINATED, "The fraction of features to be eliminated at each iteration", 0.0, 1.0, 0.1));
        return types;
    }

    public Vector<Double> arrayStringToVectorDouble(String[] array) {
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < array.length; ++i) {
            vector.add(Double.parseDouble(array[i]));
        }
        return vector;
    }
}

