/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.averaging;

import java.util.Arrays;
import java.util.List;
import timeseriesclustering.DTW;
import timeseriesclustering.DTWInformation;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.averaging.AveragingTechnique;

public class FixpointAveraging
extends AveragingTechnique {
    public double sum;
    public static final double epsilon = 0.98;

    public Double[] project(List<Double[]> base, DTWInformation[] informations, Double[] population, GlobalConstraint con) {
        Double[] ret = new Double[population.length];
        int[] alpha = new int[population.length];
        for (int j = 0; j < base.size(); ++j) {
            for (int[] a : informations[j].warpingPath) {
                if (alpha[a[1]] == 0) {
                    ret[a[1]] = 0.0;
                }
                Double[] doubleArray = ret;
                int n = a[1];
                Double.valueOf(doubleArray[n] + base.get(j)[a[0]]);
                int n2 = a[1];
                alpha[n2] = alpha[n2] + 1;
            }
        }
        for (int i = 0; i < population.length; ++i) {
            Double[] doubleArray = ret;
            int n = i;
            Double.valueOf(doubleArray[n] / (double)alpha[i]);
        }
        return ret;
    }

    public Double[] findCentroid(List<Double[]> base, GlobalConstraint con) {
        Double[] start = (Double[])base.get((int)(Math.random() * (double)base.size())).clone();
        return this.findCentroid(base, start, con);
    }

    public Double[] findCentroid(List<Double[]> base, Double[] start, GlobalConstraint con) {
        Object[] old = start;
        Object[] current = start;
        double oldSum = Double.POSITIVE_INFINITY;
        int counter = 0;
        while (true) {
            DTWInformation[] informations = new DTWInformation[base.size()];
            this.sum = 0.0;
            for (int i = 0; i < base.size(); ++i) {
                informations[i] = DTW.dtw(base.get(i), (Double[])current, Double.POSITIVE_INFINITY, 0.0, null, null, con);
                this.sum += informations[i].distance;
            }
            if (oldSum == 0.0 || this.sum / oldSum > 1.01) {
                if (oldSum != 0.0) {
                    System.out.println("Der Fixpunktbeweis den du gemacht hast ist FALSCH! " + counter + " " + this.sum + " " + oldSum);
                }
                this.sum = oldSum;
                return old;
            }
            if (this.sum / oldSum > 0.98) {
                return current;
            }
            old = current;
            if (Arrays.equals(current = this.project(base, informations, (Double[])current, con), old)) {
                return current;
            }
            oldSum = this.sum;
            ++counter;
        }
    }

    @Override
    public Double[] average(List<Double[]> cluster, Double[] oldCenter, GlobalConstraint con) {
        return this.findCentroid(cluster, oldCenter, con);
    }

    @Override
    public AveragingTechnique[] duplicateKTimes(int k) {
        AveragingTechnique[] ret = new AveragingTechnique[k];
        for (int i = 0; i < k; ++i) {
            ret[i] = new FixpointAveraging();
        }
        return ret;
    }
}

