/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.averaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import timeseriesclustering.DTW;
import timeseriesclustering.DTWInformation;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.ShapeBasedAveraging;

public class FastShapeBasedAveraging
extends ShapeBasedAveraging {
    @Override
    public Double[] average(List<Double[]> cluster, Double[] oldCenter, GlobalConstraint con) {
        HashMap<Double[], Double> distances = new HashMap<Double[], Double>(cluster.size());
        for (Double[] ts : cluster) {
            distances.put(ts, DTW.dtw((Double[])ts, (Double[])oldCenter, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance);
        }
        cluster = new ArrayList<Double[]>(cluster);
        HashMap<Double[], Double> weights = new HashMap<Double[], Double>(cluster.size());
        for (Double[] a : cluster) {
            weights.put(a, 1.0);
        }
        while (cluster.size() > 1) {
            double minDist = Double.POSITIVE_INFINITY;
            Double[] q = null;
            Double[] ts = null;
            for (int i = 0; i < cluster.size(); ++i) {
                for (int j = i + 1; j < cluster.size(); ++j) {
                    double d = Math.abs((Double)distances.get(cluster.get(i)) - (Double)distances.get(cluster.get(j)));
                    if (!(d < minDist)) continue;
                    q = cluster.get(i);
                    ts = cluster.get(j);
                    minDist = d;
                }
            }
            DTWInformation dtw = DTW.dtw(q, ts, Double.POSITIVE_INFINITY, 0.0, null, null, con);
            double weightQ = (Double)weights.get(q);
            double weightC = (Double)weights.get(ts);
            double nenner = weightQ + weightC;
            Double[] value = new Double[dtw.warpingPath.length];
            Double[] time = new Double[dtw.warpingPath.length];
            for (int i = 0; i < dtw.warpingPath.length; ++i) {
                int[] p = dtw.warpingPath[i];
                time[i] = ((double)p[0] * weightQ + (double)p[1] * weightC) / nenner;
                value[i] = (q[p[0]] * weightQ + ts[p[1]] * weightC) / nenner;
            }
            Double[] joint = this.resample(time, value);
            cluster.remove(q);
            cluster.remove(ts);
            cluster.add(joint);
            weights.put(joint, nenner);
            distances.put(joint, DTW.dtw((Double[])joint, (Double[])oldCenter, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance);
        }
        return cluster.get(0);
    }

    @Override
    public AveragingTechnique[] duplicateKTimes(int k) {
        AveragingTechnique[] ret = new AveragingTechnique[k];
        for (int i = 0; i < k; ++i) {
            ret[i] = new FastShapeBasedAveraging();
        }
        return ret;
    }
}

