/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesclustering.LogType;
import timeseriesclustering.Pair;

public class DataLogger {
    private LinkedList<Pair> events = new LinkedList();

    public void logTotalCost(double a) {
        this.events.add(new Pair(LogType.TOTALCOST, a));
    }

    public void logTotalCostPreAverage(double a) {
        this.events.add(new Pair(LogType.TOTALCOST_PREAVERAGE, a));
    }

    public void logIteration(double a) {
        this.events.add(new Pair(LogType.ITERATION, a));
    }

    public void logFailed() {
        this.events.add(new Pair(LogType.FAILED, 0.0));
    }

    public void logNewRun() {
        this.events.add(new Pair(LogType.NEW_RUN, Double.valueOf(System.currentTimeMillis())));
    }

    public void logEndRun() {
        this.events.add(new Pair(LogType.END_RUN, Double.valueOf(System.currentTimeMillis())));
    }

    public void logClusterSize(double a) {
        this.events.add(new Pair(LogType.CLUSTER_SIZE, a));
    }

    public void logAccuracy(double a) {
        this.events.add(new Pair(LogType.ACURRACY, a));
    }

    public void logDTWCount(double a) {
        this.events.add(new Pair(LogType.DTWCOUNT, a));
    }

    public void exportCosts(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            double lastCost = 0.0;
            for (Pair a : this.events) {
                if (a.fst == LogType.TOTALCOST) {
                    lastCost = a.snd;
                }
                if (a.fst != LogType.END_RUN) continue;
                bw.write(lastCost + "\n");
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportIterations(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            double lastCost = 0.0;
            for (Pair a : this.events) {
                if (a.fst == LogType.ITERATION) {
                    lastCost = a.snd;
                }
                if (a.fst != LogType.END_RUN) continue;
                bw.write(lastCost + "\n");
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportFailures(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            boolean lastFailed = false;
            for (Pair a : this.events) {
                if (a.fst == LogType.FAILED) {
                    lastFailed = true;
                }
                if (a.fst != LogType.END_RUN) continue;
                if (lastFailed) {
                    bw.write("1\n");
                } else {
                    bw.write("0\n");
                }
                lastFailed = false;
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportAccuracy(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            for (Pair a : this.events) {
                if (a.fst != LogType.ACURRACY) continue;
                bw.write(a.snd + "\n");
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportDTWCount(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            for (Pair a : this.events) {
                if (a.fst != LogType.DTWCOUNT) continue;
                bw.write(a.snd + "\n");
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportClusterSizes(String filename) {
        FileWriter writer = null;
        try {
            File f = new File(filename);
            writer = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(writer);
            ArrayList<Integer> blub = new ArrayList<Integer>();
            for (Pair a : this.events) {
                if (a.fst == LogType.ITERATION) {
                    blub.clear();
                }
                if (a.fst == LogType.CLUSTER_SIZE) {
                    blub.add(a.snd.intValue());
                }
                if (a.fst != LogType.END_RUN) continue;
                Collections.sort(blub);
                Iterator i$ = blub.iterator();
                while (i$.hasNext()) {
                    int b = (Integer)i$.next();
                    bw.write(b + " ");
                }
                bw.write("\n");
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportClusterSizeProgress(String filename) {
        FileWriter writer = null;
        try {
            int i = 1;
            int iteration = 0;
            ArrayList<Integer> blub = new ArrayList<Integer>();
            File f = null;
            BufferedWriter bw = null;
            for (Pair a : this.events) {
                if (a.fst == LogType.NEW_RUN) {
                    f = new File(filename + i);
                    writer = new FileWriter(f);
                    bw = new BufferedWriter(writer);
                    ++i;
                    iteration = 0;
                }
                if (a.fst == LogType.ITERATION) {
                    iteration = a.snd.intValue();
                    if (blub.size() > 0) {
                        bw.write(iteration + " ");
                        Iterator i$ = blub.iterator();
                        while (i$.hasNext()) {
                            int b = (Integer)i$.next();
                            bw.write(b + " ");
                        }
                        bw.write("\n");
                    }
                    blub.clear();
                }
                if (a.fst == LogType.CLUSTER_SIZE) {
                    blub.add(a.snd.intValue());
                }
                if (a.fst != LogType.END_RUN) continue;
                bw.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exportCostProgress(String filename) {
        FileWriter writer = null;
        try {
            int i = 1;
            int iteration = 0;
            double precost = 0.0;
            File f = null;
            BufferedWriter bw = null;
            for (Pair a : this.events) {
                if (a.fst == LogType.NEW_RUN) {
                    f = new File(filename + i);
                    writer = new FileWriter(f);
                    bw = new BufferedWriter(writer);
                    ++i;
                    iteration = 0;
                }
                if (a.fst == LogType.ITERATION) {
                    iteration = a.snd.intValue();
                }
                if (a.fst == LogType.TOTALCOST) {
                    bw.write(iteration + " " + precost + "\n");
                    bw.write((double)iteration + 0.5 + " " + a.snd + "\n");
                }
                if (a.fst == LogType.TOTALCOST_PREAVERAGE) {
                    precost = a.snd;
                }
                if (a.fst != LogType.END_RUN) continue;
                bw.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

