/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RealCSVLoader
extends Operator {
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public RealCSVLoader(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws UserError {
        File f = this.getParameterAsFile("file");
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            ArrayList<double[]> rows = new ArrayList<double[]>();
            String l = in.readLine();
            while (l != null) {
                String[] doubles = l.split(";");
                if (attributes.size() == 0) {
                    for (int i = 0; i < this.countCommas(l); ++i) {
                        attributes.add(AttributeFactory.createAttribute((String)("att" + i), (int)4));
                    }
                }
                double[] example = new double[attributes.size()];
                for (int i = 0; i < attributes.size(); ++i) {
                    example[i] = i >= doubles.length || doubles[i].equals("") ? Double.NaN : Double.parseDouble(doubles[i]);
                }
                rows.add(example);
                l = in.readLine();
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (double[] a : rows) {
                table.addDataRow((DataRow)new DoubleArrayDataRow(a));
            }
            ExampleSet result = table.createExampleSet();
            this.exampleSetOutput.deliver((IOObject)result);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int countCommas(String l) {
        int i = 0;
        for (int j = 0; j < l.length(); ++j) {
            if (l.charAt(j) != ';') continue;
            ++i;
        }
        return i;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("file", "the csv to load", false, new String[]{"csv", "dat"}));
        return types;
    }
}

