/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import weka.gui.LogPanel;
import weka.gui.Logger;

public class SaveBuffer {
    private Logger m_Log;
    private Component m_parentComponent;
    private String m_lastvisitedDirectory = null;

    public SaveBuffer(Logger log, Component parent) {
        this.m_Log = log;
        this.m_parentComponent = parent;
    }

    public boolean save(StringBuffer buf) {
        if (buf != null) {
            JFileChooser fileChooser = this.m_lastvisitedDirectory == null ? new JFileChooser(new File(System.getProperty("user.dir"))) : new JFileChooser(this.m_lastvisitedDirectory);
            fileChooser.setFileSelectionMode(0);
            int returnVal = fileChooser.showSaveDialog(this.m_parentComponent);
            if (returnVal == 0) {
                File sFile = fileChooser.getSelectedFile();
                this.m_lastvisitedDirectory = sFile.getPath();
                if (sFile.exists()) {
                    Object[] options = new String[]{"Append", "Overwrite", "Choose new name", "Cancel"};
                    JOptionPane jop = new JOptionPane("File exists", 3, 1, null, options);
                    JDialog dialog = jop.createDialog(this.m_parentComponent, "File query");
                    dialog.setVisible(true);
                    Object selectedValue = jop.getValue();
                    if (selectedValue != null) {
                        for (int i = 0; i < 4; ++i) {
                            if (!options[i].equals(selectedValue)) continue;
                            switch (i) {
                                case 0: {
                                    return this.saveOverwriteAppend(buf, sFile, true);
                                }
                                case 1: {
                                    return this.saveOverwriteAppend(buf, sFile, false);
                                }
                                case 2: {
                                    return this.save(buf);
                                }
                            }
                        }
                    }
                } else {
                    this.saveOverwriteAppend(buf, sFile, false);
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private boolean saveOverwriteAppend(StringBuffer buf, File sFile, boolean append) {
        try {
            String path = sFile.getPath();
            if (this.m_Log != null) {
                if (append) {
                    this.m_Log.statusMessage("Appending to file...");
                } else {
                    this.m_Log.statusMessage("Saving to file...");
                }
            }
            PrintWriter out2 = new PrintWriter(new BufferedWriter(new FileWriter(path, append)));
            out2.write(buf.toString(), 0, buf.toString().length());
            out2.close();
            if (this.m_Log != null) {
                this.m_Log.statusMessage("OK");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.m_Log != null) {
                this.m_Log.logMessage(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("SaveBuffer test");
            jf.getContentPane().setLayout(new BorderLayout());
            LogPanel lp = new LogPanel();
            JButton jb = new JButton("Save");
            jf.getContentPane().add((Component)jb, "South");
            jf.getContentPane().add((Component)lp, "Center");
            final SaveBuffer svb = new SaveBuffer(lp, jf);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    svb.save(new StringBuffer("A bit of test text"));
                }
            });
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

