/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import weka.gui.Loader;

public class ComponentHelper {
    public static final String[] IMAGES = new String[]{"weka/gui/", "weka/gui/images/"};

    public static ImageIcon getImageIcon(String dir2, String filename) {
        ImageIcon result = null;
        URL url = Loader.getURL(dir2, filename);
        if (url == null) {
            for (int i = 0; i < IMAGES.length && (url = Loader.getURL(IMAGES[i], filename)) == null; ++i) {
            }
        }
        if (url != null) {
            result = new ImageIcon(url);
        }
        return result;
    }

    public static ImageIcon getImageIcon(String filename) {
        return ComponentHelper.getImageIcon("", filename);
    }

    public static Image getImage(String dir2, String filename) {
        Image result = null;
        ImageIcon img = ComponentHelper.getImageIcon(dir2, filename);
        if (img != null) {
            result = img.getImage();
        }
        return result;
    }

    public static Image getImage(String filename) {
        Image result = null;
        ImageIcon img = ComponentHelper.getImageIcon(filename);
        if (img != null) {
            result = img.getImage();
        }
        return result;
    }

    public static int showMessageBox(Component parent, String title, String msg, int buttons, int messageType) {
        String icon;
        switch (messageType) {
            case 0: {
                icon = "weka/gui/images/error.gif";
                break;
            }
            case 1: {
                icon = "weka/gui/images/information.gif";
                break;
            }
            case 2: {
                icon = "weka/gui/images/information.gif";
                break;
            }
            case 3: {
                icon = "weka/gui/images/question.gif";
                break;
            }
            default: {
                icon = "weka/gui/images/information.gif";
            }
        }
        return JOptionPane.showConfirmDialog(parent, msg, title, buttons, messageType, ComponentHelper.getImageIcon(icon));
    }

    public static String showInputBox(Component parent, String title, String msg, Object initialValue) {
        Object result;
        if (title == null) {
            title = "Input...";
        }
        if ((result = JOptionPane.showInputDialog(parent, msg, title, 3, ComponentHelper.getImageIcon("question.gif"), null, initialValue)) != null) {
            return result.toString();
        }
        return null;
    }
}

