/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class CSVResultListener
implements ResultListener,
OptionHandler,
RevisionHandler {
    static final long serialVersionUID = -623185072785174658L;
    protected ResultProducer m_RP;
    protected File m_OutputFile = null;
    protected String m_OutputFileName = "";
    protected transient PrintWriter m_Out = new PrintWriter(System.out, true);

    public CSVResultListener() {
        File resultsFile;
        try {
            resultsFile = File.createTempFile("weka_experiment", ".csv");
            resultsFile.deleteOnExit();
        }
        catch (Exception e) {
            System.err.println("Cannot create temp file, writing to standard out.");
            resultsFile = new File("-");
        }
        this.setOutputFile(resultsFile);
        this.setOutputFileName("");
    }

    public String globalInfo() {
        return "Takes results from a result producer and assembles them into comma separated value form.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tThe filename where output will be stored. Use - for stdout.\n\t(default temp file)", "O", 1, "-O <file name>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String fName = Utils.getOption('O', options);
        if (fName.length() != 0) {
            this.setOutputFile(new File(fName));
        } else {
            File resultsFile;
            try {
                resultsFile = File.createTempFile("weka_experiment", null);
                resultsFile.deleteOnExit();
            }
            catch (Exception e) {
                System.err.println("Cannot create temp file, writing to standard out.");
                resultsFile = new File("-");
            }
            this.setOutputFile(resultsFile);
            this.setOutputFileName("");
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        options[current++] = "-O";
        options[current++] = this.getOutputFile().getName();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String outputFileTipText() {
        return "File to save to. Use '-' to write to standard out.";
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File newOutputFile) {
        this.m_OutputFile = newOutputFile;
        this.setOutputFileName(newOutputFile.getName());
    }

    public String outputFileName() {
        return this.m_OutputFileName;
    }

    public void setOutputFileName(String name) {
        this.m_OutputFileName = name;
    }

    @Override
    public void preProcess(ResultProducer rp) throws Exception {
        this.m_RP = rp;
        this.m_Out = this.m_OutputFile == null || this.m_OutputFile.getName().equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.m_OutputFile)), true);
        this.printResultNames(this.m_RP);
    }

    @Override
    public void postProcess(ResultProducer rp) throws Exception {
        if (this.m_OutputFile != null && !this.m_OutputFile.getName().equals("-")) {
            this.m_Out.close();
        }
    }

    @Override
    public String[] determineColumnConstraints(ResultProducer rp) throws Exception {
        return null;
    }

    @Override
    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        int i;
        if (this.m_RP != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        for (i = 0; i < key.length; ++i) {
            if (i != 0) {
                this.m_Out.print(',');
            }
            if (key[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(Utils.quote(key[i].toString()));
        }
        for (i = 0; i < result.length; ++i) {
            this.m_Out.print(',');
            if (result[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(Utils.quote(result[i].toString()));
        }
        this.m_Out.println("");
    }

    @Override
    public boolean isResultRequired(ResultProducer rp, Object[] key) throws Exception {
        return true;
    }

    private void printResultNames(ResultProducer rp) throws Exception {
        String[] key = rp.getKeyNames();
        for (int i = 0; i < key.length; ++i) {
            if (i != 0) {
                this.m_Out.print(',');
            }
            if (key[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print("Key_" + key[i].toString());
        }
        String[] result = rp.getResultNames();
        for (int i = 0; i < result.length; ++i) {
            this.m_Out.print(',');
            if (result[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(result[i].toString());
        }
        this.m_Out.println("");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

