/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Point;
import java.util.List;
import org.apache.log4j.Category;
import salvo.jesus.graph.GraphException;
import salvo.jesus.graph.Tree;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.Grid;

class TreeGridAdjuster
implements Visitor {
    VisualGraph vGraph;
    Tree tree;
    Vertex parentNode;
    Grid grid;
    int insertedColumnX;
    boolean adjustToRight;
    static Category logCategory = Category.getInstance((class$salvo$jesus$graph$visual$layout$Grid == null ? (class$salvo$jesus$graph$visual$layout$Grid = TreeGridAdjuster.class$("salvo.jesus.graph.visual.layout.Grid")) : class$salvo$jesus$graph$visual$layout$Grid).getName());
    static /* synthetic */ Class class$salvo$jesus$graph$visual$layout$Grid;

    public TreeGridAdjuster(VisualGraph vGraph, Vertex parentNode, Grid grid, int insertedColumnX) {
        this.vGraph = vGraph;
        this.tree = (Tree)this.vGraph.getGraph();
        this.parentNode = parentNode;
        this.grid = grid;
        this.insertedColumnX = insertedColumnX;
    }

    public void adjust() {
        List children;
        try {
            children = this.tree.getChildren(this.parentNode);
        }
        catch (GraphException ex) {
            ex.printStackTrace();
            return;
        }
        VisualVertex immediateRightChild = null;
        VisualVertex immediateLeftChild = null;
        int immediateRightChildX = this.grid.getWidth();
        int immediateLeftChildX = 0;
        for (int i = 0; i < children.size(); ++i) {
            VisualVertex vVertex = this.vGraph.getVisualVertex((Vertex)children.get(i));
            Point vertexPoint = this.grid.findVisualVertex(vVertex);
            if (vertexPoint.x > this.insertedColumnX && (immediateRightChild == null || vertexPoint.x < immediateRightChildX)) {
                immediateRightChild = vVertex;
                immediateRightChildX = vertexPoint.x;
            }
            if (vertexPoint.x >= this.insertedColumnX || immediateLeftChild != null && vertexPoint.x <= immediateLeftChildX) continue;
            immediateLeftChild = vVertex;
            immediateLeftChildX = vertexPoint.x;
        }
        if (immediateRightChild != null) {
            this.adjustToRight = true;
            this.visit(immediateRightChild.getVertex());
        }
        if (immediateLeftChild != null) {
            this.adjustToRight = false;
            this.visit(immediateLeftChild.getVertex());
        }
    }

    public boolean visit(Vertex vertexToVisit) {
        List children;
        try {
            children = this.tree.getChildren(vertexToVisit);
        }
        catch (GraphException ex) {
            ex.printStackTrace();
            return false;
        }
        int numberOfChildren = children.size();
        Point parentPoint = this.grid.findVisualVertex(this.vGraph.getVisualVertex(vertexToVisit));
        for (int i = 0; i < numberOfChildren; ++i) {
            VisualVertex vVertex = this.vGraph.getVisualVertex((Vertex)children.get(i));
            Point childPoint = this.grid.findVisualVertex(vVertex);
            if (this.adjustToRight && childPoint.x < parentPoint.x) {
                if (childPoint.x < this.insertedColumnX) {
                    logCategory.debug("Moving " + vVertex + " from " + childPoint + " to (" + (childPoint.x + 1) + "," + childPoint.y);
                    this.grid.setGridPoint(childPoint.x + 1, childPoint.y, vVertex);
                }
                this.visit((Vertex)children.get(i));
            }
            if (this.adjustToRight || childPoint.x <= parentPoint.x) continue;
            if (childPoint.x > this.insertedColumnX) {
                logCategory.debug("Moving " + vVertex + " from " + childPoint + " to (" + (childPoint.x - 1) + "," + childPoint.y);
                this.grid.setGridPoint(childPoint.x - 1, childPoint.y, vVertex);
            }
            this.visit((Vertex)children.get(i));
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

