/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Category;
import salvo.jesus.graph.Tree;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.algorithm.BreadthFirstTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;
import salvo.jesus.graph.visual.layout.VertexDegrees;

public class RadialTreeLayout
implements GraphLayoutManager,
Visitor {
    VisualGraph vGraph;
    Tree tree;
    HashMap annulusWedgeMap;
    Point2D center = null;
    double radius = 100.0;
    int previousDepth = 0;
    double depthStartAtDegrees = 0.0;
    Vertex previousParent = null;
    private boolean initialized = false;
    static Category logCategory = Category.getInstance((class$salvo$jesus$graph$visual$layout$LayeredTreeLayout == null ? (class$salvo$jesus$graph$visual$layout$LayeredTreeLayout = RadialTreeLayout.class$("salvo.jesus.graph.visual.layout.LayeredTreeLayout")) : class$salvo$jesus$graph$visual$layout$LayeredTreeLayout).getName());
    static /* synthetic */ Class class$salvo$jesus$graph$visual$layout$LayeredTreeLayout;

    public RadialTreeLayout(VisualGraph vGraph) {
        this.vGraph = vGraph;
        this.tree = (Tree)vGraph.getGraph();
        this.annulusWedgeMap = new HashMap();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void layout() {
        ArrayList visited = new ArrayList(10);
        BreadthFirstTraversal traversal = new BreadthFirstTraversal(this.tree);
        ((GraphTraversal)traversal).traverse(this.tree.getRoot(), visited, this);
        this.drawLayout();
    }

    public boolean visit(Vertex vertexToVisit) {
        VertexDegrees degrees = new VertexDegrees();
        logCategory.debug("Visiting " + vertexToVisit);
        try {
            VisualVertex visualVertex = this.vGraph.getVisualVertex(vertexToVisit);
            int depth = this.tree.getDepth(vertexToVisit);
            logCategory.debug("Depth: " + depth);
            if (this.tree.getRoot() == vertexToVisit) {
                double annulusWedgeDegree = 360.0;
                this.center = new Point2D.Double((double)this.tree.getHeight() * this.radius / 2.0, (double)this.tree.getHeight() * this.radius / 2.0);
                logCategory.debug("Setting center " + this.center);
                visualVertex.setLocation(this.center.getX(), this.center.getY());
                degrees.annulusWedgeDegree = annulusWedgeDegree;
                degrees.positionDegree = 0.0;
                this.annulusWedgeMap.put(vertexToVisit, degrees);
                this.previousParent = vertexToVisit;
            } else {
                Vertex parent = this.tree.getParent(vertexToVisit);
                VertexDegrees parentDegrees = (VertexDegrees)this.annulusWedgeMap.get(parent);
                double parentAnnulusWedge = parentDegrees.annulusWedgeDegree;
                Tree parentSubTree = this.tree.getSubTree(parent);
                Tree subTree = this.tree.getSubTree(vertexToVisit);
                double annulusWedgeDegree = Math.min((double)subTree.getLeaves().size() / (double)parentSubTree.getLeaves().size() * parentAnnulusWedge, Math.toDegrees(Math.acos(this.radius * (double)(depth - 1) / (this.radius * (double)depth))) * 2.0);
                logCategory.debug("Annulus Wedge: " + annulusWedgeDegree);
                if (this.previousDepth != this.tree.getDepth(vertexToVisit)) {
                    this.depthStartAtDegrees = parentDegrees.positionDegree - parentDegrees.annulusWedgeDegree / 2.0;
                }
                if (this.previousParent != parent) {
                    this.depthStartAtDegrees = parentDegrees.positionDegree - parentDegrees.annulusWedgeDegree / 2.0;
                }
                double positionDegree = this.depthStartAtDegrees + annulusWedgeDegree / 2.0;
                logCategory.debug("Start At:" + this.depthStartAtDegrees);
                logCategory.debug("Position:" + positionDegree);
                Arc2D.Double arc = new Arc2D.Double(this.center.getX() - this.radius / 2.0 * (double)(depth - 1), this.center.getY() - this.radius / 2.0 * (double)(depth - 1), this.radius * (double)(depth - 1), this.radius * (double)(depth - 1), positionDegree, 1.0, 0);
                visualVertex.setLocation(arc.getEndPoint().getX(), arc.getEndPoint().getY());
                degrees.annulusWedgeDegree = annulusWedgeDegree;
                degrees.positionDegree = positionDegree;
                this.annulusWedgeMap.put(vertexToVisit, degrees);
                this.depthStartAtDegrees += annulusWedgeDegree;
                this.previousDepth = this.tree.getDepth(vertexToVisit);
                this.previousParent = parent;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void addVertex(VisualVertex vVertex) {
    }

    public void removeEdge(VisualEdge vEdge) {
    }

    public void removeVertex(VisualVertex vVertex) {
    }

    public void addEdge(VisualEdge vEdge) {
    }

    public void routeEdge(Graphics2D g2d, VisualEdge vEdge) {
        VisualVertex visualVertexA = vEdge.getVisualVertexA();
        VisualVertex visualVertexB = vEdge.getVisualVertexB();
        GeneralPath drawPath = vEdge.getGeneralPath();
        Rectangle fromvertexBounds = visualVertexA.getBounds();
        Rectangle tovertexBounds = visualVertexB.getBounds();
        drawPath.reset();
        drawPath.moveTo((float)fromvertexBounds.getCenterX(), (float)fromvertexBounds.getCenterY());
        drawPath.lineTo((float)tovertexBounds.getCenterX(), (float)tovertexBounds.getCenterY());
    }

    public void drawLayout() {
        this.vGraph.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

