/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import salvo.jesus.graph.visual.VisualVertex;

public class Grid
implements Serializable {
    List visualVertices;
    List grid;
    List gridPointAssignment;
    static Category logCategory = Category.getInstance((class$salvo$jesus$graph$visual$layout$Grid == null ? (class$salvo$jesus$graph$visual$layout$Grid = Grid.class$("salvo.jesus.graph.visual.layout.Grid")) : class$salvo$jesus$graph$visual$layout$Grid).getName());
    static /* synthetic */ Class class$salvo$jesus$graph$visual$layout$Grid;

    public Grid(List visualVertices) {
        this.visualVertices = visualVertices;
        this.initGrid();
    }

    public Grid(List visualVertices, int width, int height) {
        this.visualVertices = visualVertices;
        this.initGrid(width, height);
    }

    protected void initGrid(int width, int height) {
        int i;
        ArrayList xgrid = new ArrayList(width);
        for (i = 0; i < width; ++i) {
            ArrayList<VisualVertex> ygrid = new ArrayList<VisualVertex>(height);
            for (int j = 0; j < height; ++j) {
                ygrid.add(null);
            }
            xgrid.add(ygrid);
        }
        this.grid = xgrid;
        int size = this.visualVertices.size();
        this.gridPointAssignment = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            this.gridPointAssignment.add(null);
        }
    }

    protected void initGrid() {
        int dimension = this.visualVertices.size();
        this.initGrid(dimension, dimension);
    }

    public int getGridSize() {
        return this.grid.size();
    }

    public int getStartingXGridPoint() {
        int height = this.getHeight();
        int width = this.getWidth();
        for (int i = 0; i < width; ++i) {
            List ygrid = (List)this.grid.get(i);
            height = ygrid.size();
            for (int j = 0; j < height; ++j) {
                if (ygrid.get(j) == null) continue;
                return i;
            }
        }
        return -1;
    }

    public int getStartingYGridPoint() {
        int height = this.getHeight();
        int width = this.getWidth();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                List ygrid = (List)this.grid.get(i);
                if (ygrid.get(j) == null) continue;
                return j;
            }
        }
        return -1;
    }

    public int getWidth() {
        return this.grid.size();
    }

    public int getHeight() {
        int maxHeight = 0;
        int width = this.getWidth();
        if (width == 0) {
            return 0;
        }
        for (int i = 0; i < width; ++i) {
            List sampleYGrid = (List)this.grid.get(i);
            maxHeight = Math.max(maxHeight, sampleYGrid.size());
        }
        return maxHeight;
    }

    public void setGridPoint(int x, int y, VisualVertex vvertex) {
        List ygrid;
        int size = this.grid.size();
        for (int xi = 0; xi < size; ++xi) {
            ygrid = (List)this.grid.get(xi);
            int previousypoint = ygrid.indexOf(vvertex);
            if (previousypoint < 0) continue;
            ygrid.set(previousypoint, null);
        }
        ygrid = (List)this.grid.get(x);
        ygrid.set(y, vvertex);
        Point point = new Point(x, y);
        logCategory.debug("Setting index for " + vvertex + " at " + point);
        this.gridPointAssignment.set(this.visualVertices.indexOf(vvertex), point);
        logCategory.debug(this.gridPointAssignment);
    }

    public VisualVertex getGridPoint(int x, int y) {
        List ygrid = (List)this.grid.get(x);
        return (VisualVertex)ygrid.get(y);
    }

    public Point findVisualVertex(VisualVertex v) {
        return (Point)this.gridPointAssignment.get(this.visualVertices.indexOf(v));
    }

    public void appendToRight(Grid gridtoappend) {
        int origwidthgrid = this.getWidth();
        int addsize = gridtoappend.gridPointAssignment.size();
        this.grid.addAll(gridtoappend.grid);
        this.visualVertices.addAll(gridtoappend.visualVertices);
        for (int i = 0; i < addsize; ++i) {
            Point point = (Point)gridtoappend.gridPointAssignment.get(i);
            point.translate(origwidthgrid, 0);
            gridtoappend.gridPointAssignment.set(i, point);
        }
        this.gridPointAssignment.addAll(gridtoappend.gridPointAssignment);
    }

    public void appendToBottom(Grid gridtoappend) {
        int i;
        int origHeightGrid = this.getHeight();
        int addsize = gridtoappend.gridPointAssignment.size();
        for (i = 0; i < this.getWidth(); ++i) {
            List yGrid = (List)this.grid.get(i);
            List yGridtoAppend = (List)gridtoappend.grid.get(i);
            yGrid.addAll(yGridtoAppend);
            logCategory.debug("\tSize of y grid to append: " + yGridtoAppend.size());
        }
        this.visualVertices.addAll(gridtoappend.visualVertices);
        for (i = 0; i < addsize; ++i) {
            Point point = (Point)gridtoappend.gridPointAssignment.get(i);
            point.translate(0, origHeightGrid);
            gridtoappend.gridPointAssignment.set(i, point);
        }
        this.gridPointAssignment.addAll(gridtoappend.gridPointAssignment);
    }

    public void insertEmptyGrid(int insertBeforeIndex) {
        ArrayList<VisualVertex> newRows = new ArrayList<VisualVertex>(10);
        for (int j = 0; j < this.getHeight(); ++j) {
            newRows.add(null);
        }
        this.grid.add(insertBeforeIndex, newRows);
        int width = this.getWidth();
        for (int i = insertBeforeIndex + 1; i < width; ++i) {
            List yGrid = (List)this.grid.get(i);
            for (int yGridIndex = 0; yGridIndex < yGrid.size(); ++yGridIndex) {
                VisualVertex vv = (VisualVertex)yGrid.get(yGridIndex);
                if (vv == null) continue;
                int vvIndex = this.visualVertices.indexOf(vv);
                Point point = (Point)this.gridPointAssignment.get(vvIndex);
                point.translate(1, 0);
            }
        }
    }

    public String toString() {
        int x;
        StringBuffer output = new StringBuffer("\n");
        int width = this.getWidth();
        int height = this.getHeight();
        output.append("\n--------------------\nColumn:");
        for (x = 0; x < width; ++x) {
            output.append("\t\t" + x);
        }
        output.append("\n--------------------\n");
        for (int y = 0; y < height; ++y) {
            output.append("Line " + y + ":\t\t");
            for (x = 0; x < width; ++x) {
                List ygrid = (List)this.grid.get(x);
                VisualVertex v = y <= ygrid.size() - 1 && ygrid.get(y) != null ? (VisualVertex)ygrid.get(y) : null;
                output.append((v != null ? v.toString() : "") + "\t\t");
            }
            output.append("\n");
        }
        output.append("--------------------\n");
        return output.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

