/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector;

import java.text.NumberFormat;
import java.util.Random;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.operation.VectorMatrixOperation;
import org.la4j.operation.VectorOperation;
import org.la4j.operation.VectorVectorOperation;
import org.la4j.vector.dense.BasicVector;

public abstract class DenseVector
extends Vector {
    public static DenseVector zero(int length) {
        return BasicVector.zero(length);
    }

    public static DenseVector constant(int length, double value) {
        return BasicVector.constant(length, value);
    }

    public static DenseVector unit(int length) {
        return DenseVector.constant(length, 1.0);
    }

    public static DenseVector random(int length, Random random) {
        return BasicVector.random(length, random);
    }

    public static DenseVector fromArray(double[] array) {
        return BasicVector.fromArray(array);
    }

    public static DenseVector fromCSV(String csv) {
        return Vector.fromCSV(csv).to(Vectors.DENSE);
    }

    public static DenseVector fromMatrixMarket(String mm) {
        return Vector.fromMatrixMarket(mm).to(Vectors.DENSE);
    }

    @Override
    public <T> T apply(VectorOperation<T> operation) {
        operation.ensureApplicableTo(this);
        return operation.apply(this);
    }

    @Override
    public <T> T apply(VectorVectorOperation<T> operation, Vector that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public <T> T apply(VectorMatrixOperation<T> operation, Matrix that) {
        return that.apply(operation.partiallyApply(this));
    }

    public abstract double[] toArray();

    public DenseVector(int length) {
        super(length);
    }

    @Override
    public Matrix toRowMatrix() {
        Basic2DMatrix result = Basic2DMatrix.zero(1, this.length);
        for (int j = 0; j < this.length; ++j) {
            ((Matrix)result).set(0, j, this.get(j));
        }
        return result;
    }

    @Override
    public Matrix toColumnMatrix() {
        Basic2DMatrix result = Basic2DMatrix.zero(this.length, 1);
        for (int i = 0; i < this.length; ++i) {
            ((Matrix)result).set(i, 0, this.get(i));
        }
        return result;
    }

    @Override
    public Matrix toDiagonalMatrix() {
        Basic2DMatrix result = Basic2DMatrix.zero(this.length, this.length);
        for (int i = 0; i < this.length; ++i) {
            ((Matrix)result).set(i, i, this.get(i));
        }
        return result;
    }

    @Override
    public String toMatrixMarket(NumberFormat formatter) {
        StringBuilder out2 = new StringBuilder();
        out2.append("%%MatrixMarket vector array real\n");
        out2.append(this.length).append('\n');
        for (int i = 0; i < this.length; ++i) {
            out2.append(formatter.format(this.get(i))).append('\n');
        }
        return out2.toString();
    }
}

