/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.text.NumberFormat;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.matrix.dense.Basic1DMatrix;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.operation.MatrixMatrixOperation;
import org.la4j.operation.MatrixOperation;
import org.la4j.operation.MatrixVectorOperation;
import org.la4j.vector.DenseVector;

public abstract class DenseMatrix
extends Matrix {
    public static DenseMatrix zero(int rows, int columns) {
        return Basic2DMatrix.zero(rows, columns);
    }

    public static DenseMatrix constant(int rows, int columns, double constant) {
        return Basic2DMatrix.constant(rows, columns, constant);
    }

    public static DenseMatrix diagonal(int size, double diagonal) {
        return Basic2DMatrix.diagonal(size, diagonal);
    }

    public static DenseMatrix unit(int rows, int columns) {
        return Basic2DMatrix.unit(rows, columns);
    }

    public static DenseMatrix identity(int size) {
        return Basic2DMatrix.identity(size);
    }

    public static DenseMatrix random(int rows, int columns, Random random) {
        return Basic2DMatrix.random(rows, columns, random);
    }

    public static DenseMatrix randomSymmetric(int size, Random random) {
        return Basic2DMatrix.randomSymmetric(size, random);
    }

    public static DenseMatrix from1DArray(int rows, int columns, double[] array) {
        return Basic1DMatrix.from1DArray(rows, columns, array);
    }

    public static DenseMatrix from2DArray(double[][] array) {
        return Basic2DMatrix.from2DArray(array);
    }

    public static DenseMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        return Basic2DMatrix.block(a, b, c, d);
    }

    public static DenseMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.DENSE);
    }

    public static DenseMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.DENSE);
    }

    public DenseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public abstract double[][] toArray();

    @Override
    public Vector getRow(int i) {
        DenseVector result = DenseVector.zero(this.columns);
        for (int j = 0; j < this.columns; ++j) {
            result.set(j, this.get(i, j));
        }
        return result;
    }

    @Override
    public Vector getColumn(int j) {
        DenseVector result = DenseVector.zero(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            result.set(i, this.get(i, j));
        }
        return result;
    }

    @Override
    public <T> T apply(MatrixOperation<T> operation) {
        operation.ensureApplicableTo(this);
        return operation.apply(this);
    }

    @Override
    public <T> T apply(MatrixMatrixOperation<T> operation, Matrix that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public <T> T apply(MatrixVectorOperation<T> operation, Vector that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public String toMatrixMarket(NumberFormat formatter) {
        StringBuilder out2 = new StringBuilder();
        out2.append("%%MatrixMarket matrix array real general\n");
        out2.append(this.rows).append(' ').append(this.columns).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                out2.append(formatter.format(this.get(i, j))).append('\n');
            }
        }
        return out2.toString();
    }
}

