/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.vector;

import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.data.SubsetVectors;
import org.aksw.palmetto.prob.ProbabilityEstimator;
import org.aksw.palmetto.vector.AbstractVectorCreator;

public class ProbabilityBasedVectorCreator
extends AbstractVectorCreator {
    private static final String VECTOR_CREATOR_NAME = "V_p";

    public ProbabilityBasedVectorCreator(ProbabilityEstimator supplier) {
        super(supplier);
    }

    @Override
    public String getVectorCreatorName() {
        return VECTOR_CREATOR_NAME;
    }

    @Override
    protected SubsetVectors[] createVectors(String[][] wordsets, SegmentationDefinition[] definitions, SubsetProbabilities[] probabilities) {
        SubsetVectors[] vectors = new SubsetVectors[wordsets.length];
        for (int w = 0; w < wordsets.length; ++w) {
            double[][] currentVectors = new double[wordsets[w].length][wordsets[w].length];
            for (int i = 0; i < wordsets[w].length; ++i) {
                int bit1 = 1 << i;
                currentVectors[i][i] = probabilities[w].probabilities[bit1];
                for (int j = i + 1; j < wordsets[w].length; ++j) {
                    currentVectors[i][j] = probabilities[w].probabilities[bit1 | 1 << j];
                    currentVectors[j][i] = currentVectors[i][j];
                }
            }
            vectors[w] = new SubsetVectors(definitions[w].segments, definitions[w].conditions, currentVectors, probabilities[w].probabilities);
        }
        return vectors;
    }
}

