/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.vector;

import java.util.Arrays;
import org.aksw.palmetto.calculations.direct.DirectConfirmationMeasure;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.data.SubsetVectors;
import org.aksw.palmetto.prob.ProbabilityEstimator;
import org.aksw.palmetto.subsets.OneOneAndSelf;
import org.aksw.palmetto.vector.AbstractVectorCreator;

public class DirectConfirmationBasedVectorCreator
extends AbstractVectorCreator {
    private static final int DEFAULT_GAMMA = 2;
    private DirectConfirmationMeasure calculation;
    private OneOneAndSelf oneOneAndSelfCreator = new OneOneAndSelf();
    private double gamma;

    public DirectConfirmationBasedVectorCreator(ProbabilityEstimator supplier, DirectConfirmationMeasure calculation) {
        super(supplier);
        this.calculation = calculation;
        this.gamma = 2.0;
    }

    public DirectConfirmationBasedVectorCreator(ProbabilityEstimator supplier, DirectConfirmationMeasure calculation, double gamma) {
        super(supplier);
        this.calculation = calculation;
        this.gamma = gamma;
    }

    @Override
    public String getVectorCreatorName() {
        return 'V' + this.calculation.getName().substring(1) + "(" + (int)this.gamma + ")";
    }

    @Override
    protected SubsetVectors[] createVectors(String[][] wordsets, SegmentationDefinition[] definitions, SubsetProbabilities[] probabilities) {
        SubsetVectors[] vectors = new SubsetVectors[wordsets.length];
        SegmentationDefinition oneOneAndSelfDef = this.oneOneAndSelfCreator.getSubsetDefinition(wordsets[0].length);
        SubsetProbabilities oneOneAndSelfProbabilities = new SubsetProbabilities(oneOneAndSelfDef.segments, oneOneAndSelfDef.conditions, null);
        for (int w = 0; w < wordsets.length; ++w) {
            int i;
            oneOneAndSelfProbabilities.probabilities = probabilities[w].probabilities;
            double[] calcResult = this.calculation.calculateConfirmationValues(oneOneAndSelfProbabilities);
            double[][] currentVectors = new double[wordsets[w].length][wordsets[w].length];
            int startId = 0;
            try {
                for (i = 0; i < wordsets[w].length; ++i) {
                    System.arraycopy(calcResult, startId, currentVectors[i], 0, wordsets[w].length);
                    startId += wordsets[w].length;
                }
            }
            catch (Exception e) {
                System.err.println("ERROR w=" + w + " wordsets[w]=" + Arrays.toString(wordsets[w]) + " calcResult=" + Arrays.toString(calcResult));
            }
            if (this.gamma != 1.0) {
                for (i = 0; i < wordsets[w].length; ++i) {
                    for (int j = 0; j < currentVectors[i].length; ++j) {
                        currentVectors[i][j] = Math.pow(currentVectors[i][j], this.gamma);
                    }
                }
            }
            vectors[w] = new SubsetVectors(definitions[w].segments, definitions[w].conditions, currentVectors, probabilities[w].probabilities);
        }
        return vectors;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public double getGamma() {
        return this.gamma;
    }
}

