/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.vector;

import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.data.SubsetVectors;
import org.aksw.palmetto.prob.ProbabilityEstimator;
import org.aksw.palmetto.vector.VectorCreator;

public abstract class AbstractVectorCreator
implements VectorCreator {
    private static final String VECTOR_SPACE_NAME = "V^Top";
    private ProbabilityEstimator supplier;

    public AbstractVectorCreator(ProbabilityEstimator supplier) {
        this.supplier = supplier;
    }

    @Override
    public SubsetVectors[] getVectors(String[][] wordsets, SegmentationDefinition[] definitions) {
        SubsetProbabilities[] probabilities = this.supplier.getProbabilities(wordsets, definitions);
        return this.createVectors(wordsets, definitions, probabilities);
    }

    protected abstract SubsetVectors[] createVectors(String[][] var1, SegmentationDefinition[] var2, SubsetProbabilities[] var3);

    @Override
    public String getProbabilityEstimatorName() {
        return this.supplier.getName();
    }

    @Override
    public String getVectorSpaceName() {
        return VECTOR_SPACE_NAME;
    }

    @Override
    public void setMinFrequency(int minFrequency) {
        this.supplier.setMinFrequency(minFrequency);
    }

    @Override
    public void setProbabilityEstimator(ProbabilityEstimator supplier) {
        this.supplier = supplier;
    }
}

